/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.bean;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.BuilderException;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.Path;
import org.chromattic.core.bean.ArrayPropertyInfo;
import org.chromattic.core.bean.BeanValueInfo;
import org.chromattic.core.bean.CollectionPropertyInfo;
import org.chromattic.core.bean.ListPropertyInfo;
import org.chromattic.core.bean.MapPropertyInfo;
import org.chromattic.core.bean.PropertyInfo;
import org.chromattic.core.bean.SimpleValueInfo;
import org.chromattic.core.bean.SingleValuedPropertyInfo;
import org.chromattic.core.bean.ValueInfo;
import org.reflext.api.AnnotationIntrospector;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.introspection.HierarchyScope;
import org.reflext.api.introspection.MethodIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInfo {
    private final ClassTypeInfo typeInfo;
    private final Map<String, PropertyInfo> properties;

    public BeanInfo(ClassTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
        this.properties = BeanInfo.buildProperties(typeInfo);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<PropertyInfo> getProperties() {
        return this.properties.values();
    }

    public ClassTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public PropertyInfo getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public <A extends Annotation> Collection<PropertyInfo> getProperties(Class<A> annotationClass) {
        ArrayList<PropertyInfo> matched = new ArrayList<PropertyInfo>();
        for (PropertyInfo property : this.properties.values()) {
            if (property.getAnnotation(annotationClass) == null) continue;
            matched.add(property);
        }
        return matched;
    }

    private static Map<String, PropertyInfo> buildProperties(ClassTypeInfo type) {
        PropertyInfo property;
        String name;
        MethodIntrospector introspector = new MethodIntrospector(HierarchyScope.ALL, true);
        Map getterMap = introspector.getGetterMap(type);
        Map setterMap = introspector.getSetterMap(type);
        HashMap<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
        for (Map.Entry getterEntry : getterMap.entrySet()) {
            name = (String)getterEntry.getKey();
            MethodInfo getter = (MethodInfo)getterEntry.getValue();
            TypeInfo getterTypeInfo = getter.getReturnType();
            Set setters = (Set)setterMap.get(name);
            property = null;
            if (setters != null) {
                for (MethodInfo setter : setters) {
                    TypeInfo setterTypeInfo = (TypeInfo)setter.getParameterTypes().get(0);
                    if (!getterTypeInfo.equals(setterTypeInfo)) continue;
                    property = BeanInfo.createPropertyInfo(type, name, getterTypeInfo, getter, setter);
                }
            }
            if (property == null) {
                property = BeanInfo.createPropertyInfo(type, name, getterTypeInfo, getter, null);
            }
            if (property == null) continue;
            properties.put(name, property);
        }
        setterMap.keySet().removeAll(properties.keySet());
        block2: for (Map.Entry setterEntry : setterMap.entrySet()) {
            name = (String)setterEntry.getKey();
            for (MethodInfo setter : (Set)setterEntry.getValue()) {
                TypeInfo setterTypeInfo = (TypeInfo)setter.getParameterTypes().get(0);
                property = BeanInfo.createPropertyInfo(type, name, setterTypeInfo, null, setter);
                if (property == null) continue;
                properties.put(name, property);
                continue block2;
            }
        }
        return properties;
    }

    private static ClassTypeInfo resolveClass(ClassTypeInfo baseType, TypeInfo type) {
        TypeInfo resolvedType = baseType.resolve(type);
        return resolvedType instanceof ClassTypeInfo ? (ClassTypeInfo)resolvedType : null;
    }

    private static Map<Class<? extends Annotation>, List<? extends Annotation>> getAnnotations(MethodInfo getter, MethodInfo setter, Class<? extends Annotation> ... annotationClasses) {
        HashMap<Class<? extends Annotation>, List<? extends Annotation>> annotationMap = new HashMap<Class<? extends Annotation>, List<? extends Annotation>>();
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            List<? extends Annotation> annotations = BeanInfo.getAnnotation(getter, setter, annotationClass);
            if (annotations.size() <= 0) continue;
            annotationMap.put(annotationClass, annotations);
        }
        return annotationMap;
    }

    private static <A extends Annotation> List<A> getAnnotation(MethodInfo getter, MethodInfo setter, Class<A> annotationClass) {
        Annotation setterAnnotation;
        Annotation getterAnnotation;
        AnnotationIntrospector spector = new AnnotationIntrospector(annotationClass);
        ArrayList<Annotation> list = new ArrayList<Annotation>(2);
        if (getter != null && (getterAnnotation = spector.resolve(getter)) != null) {
            list.add(getterAnnotation);
        }
        if (setter != null && (setterAnnotation = spector.resolve(setter)) != null) {
            list.add(setterAnnotation);
        }
        return list;
    }

    private static ValueInfo createValue(ClassTypeInfo type, MethodInfo getter, MethodInfo setter) throws BuilderException {
        Map<Class<? extends Annotation>, List<? extends Annotation>> annotationMap = BeanInfo.getAnnotations(getter, setter, DefaultValue.Int.class, DefaultValue.Boolean.class, DefaultValue.Long.class, DefaultValue.Float.class, DefaultValue.Double.class);
        if (annotationMap.size() > 2) {
            throw new BuilderException("Too many default value annotations");
        }
        Annotation defaultValue = null;
        if (annotationMap.size() == 1) {
            List<? extends Annotation> annotations = annotationMap.values().iterator().next();
            if (annotations.size() == 1) {
                defaultValue = annotations.get(0);
            } else {
                throw new BuilderException("Too many default value annotations");
            }
        }
        if (type instanceof SimpleTypeInfo) {
            return SimpleValueInfo.create(type, defaultValue);
        }
        if (type.getName().equals(String.class.getName())) {
            AnnotationIntrospector intro = new AnnotationIntrospector(Path.class);
            if (getter != null && intro.resolve(getter) != null || setter != null && intro.resolve(setter) != null) {
                return SimpleValueInfo.createPath(type);
            }
            return SimpleValueInfo.create(type, defaultValue);
        }
        if (type.getName().equals(InputStream.class.getName()) || type.getName().equals(Date.class.getName())) {
            return SimpleValueInfo.create(type, defaultValue);
        }
        return new BeanValueInfo(type);
    }

    private static PropertyInfo createPropertyInfo(ClassTypeInfo beanTypeInfo, String name, TypeInfo typeInfo, MethodInfo getter, MethodInfo setter) {
        TypeInfo resolvedTI = beanTypeInfo.resolve(typeInfo);
        if (resolvedTI instanceof ParameterizedTypeInfo) {
            ParameterizedTypeInfo parameterizedTI = (ParameterizedTypeInfo)resolvedTI;
            TypeInfo rawTI = parameterizedTI.getRawType();
            if (rawTI instanceof ClassTypeInfo) {
                TypeInfo elementTV;
                ClassTypeInfo elementTI;
                ClassTypeInfo rawClassTI = (ClassTypeInfo)rawTI;
                String rawClassName = rawClassTI.getName();
                if (rawClassName.equals("java.util.Collection") || rawClassName.equals("java.util.List")) {
                    TypeInfo elementTV2 = (TypeInfo)parameterizedTI.getTypeArguments().get(0);
                    ClassTypeInfo elementTI2 = BeanInfo.resolveClass(beanTypeInfo, elementTV2);
                    if (elementTI2 != null) {
                        ValueInfo resolvedElementTI = BeanInfo.createValue(elementTI2, getter, setter);
                        if (rawClassName.equals("java.util.Collection")) {
                            return new CollectionPropertyInfo<ValueInfo>(name, resolvedElementTI, getter, setter);
                        }
                        return new ListPropertyInfo<ValueInfo>(name, resolvedElementTI, getter, setter);
                    }
                } else if (rawClassName.equals("java.util.Map") && (elementTI = BeanInfo.resolveClass(beanTypeInfo, elementTV = (TypeInfo)parameterizedTI.getTypeArguments().get(1))) != null) {
                    ValueInfo resolvedElementTI = BeanInfo.createValue(elementTI, getter, setter);
                    TypeInfo keyTV = (TypeInfo)parameterizedTI.getTypeArguments().get(0);
                    ClassTypeInfo keyTI = BeanInfo.resolveClass(beanTypeInfo, keyTV);
                    if (keyTI != null) {
                        ValueInfo resolvedKeyTI = BeanInfo.createValue(keyTI, getter, setter);
                        return new MapPropertyInfo<ValueInfo, ValueInfo>(name, resolvedElementTI, resolvedKeyTI, getter, setter);
                    }
                }
            }
        } else {
            ClassTypeInfo rawComponentTI;
            ValueInfo resolved;
            TypeInfo componentTI;
            if (resolvedTI instanceof ClassTypeInfo) {
                ValueInfo resolved2 = BeanInfo.createValue((ClassTypeInfo)resolvedTI, getter, setter);
                return new SingleValuedPropertyInfo<ValueInfo>(name, resolved2, getter, setter);
            }
            if (resolvedTI instanceof ArrayTypeInfo && (componentTI = ((ArrayTypeInfo)resolvedTI).getComponentType()) instanceof ClassTypeInfo && (resolved = BeanInfo.createValue(rawComponentTI = (ClassTypeInfo)componentTI, getter, setter)) instanceof SimpleValueInfo) {
                return new ArrayPropertyInfo<SimpleValueInfo>(name, (SimpleValueInfo)resolved, getter, setter);
            }
        }
        return null;
    }
}

