/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.chromattic.core.bean.SimpleType;
import org.chromattic.core.bean.SimpleTypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMapper {
    public static final ValueMapper instance = new ValueMapper();

    private ValueMapper() {
    }

    public final <T> T get(Value value, SimpleType<T> wantedType) throws RepositoryException {
        int propertyType = value.getType();
        if (wantedType != null) {
            switch (wantedType.getKind()) {
                case BINARY: {
                    if (propertyType == 2) {
                        return (T)value.getStream();
                    }
                    throw new ClassCastException();
                }
                case STRING: {
                    if (propertyType == 1 || propertyType == 7 || propertyType == 8) {
                        return (T)value.getString();
                    }
                    throw new ClassCastException();
                }
                case PATH: {
                    if (propertyType == 8) {
                        return (T)value.getString();
                    }
                    throw new ClassCastException();
                }
                case INT: {
                    if (propertyType == 3) {
                        return (T)Integer.valueOf((int)value.getLong());
                    }
                    throw new ClassCastException();
                }
                case LONG: {
                    if (propertyType == 3) {
                        return (T)Long.valueOf(value.getLong());
                    }
                    throw new ClassCastException();
                }
                case FLOAT: {
                    if (propertyType == 4) {
                        return (T)Float.valueOf((float)value.getDouble());
                    }
                    throw new ClassCastException();
                }
                case DOUBLE: {
                    if (propertyType == 4) {
                        return (T)Double.valueOf(value.getDouble());
                    }
                    throw new ClassCastException();
                }
                case BOOLEAN: {
                    if (propertyType == 6) {
                        return (T)Boolean.valueOf(value.getBoolean());
                    }
                    throw new ClassCastException();
                }
                case DATE: {
                    if (propertyType == 5) {
                        return (T)value.getDate().getTime();
                    }
                    throw new ClassCastException();
                }
            }
            throw new AssertionError((Object)("Property type " + propertyType + " not handled"));
        }
        switch (propertyType) {
            case 6: {
                return (T)Boolean.valueOf(value.getBoolean());
            }
            case 3: {
                return (T)Integer.valueOf((int)value.getLong());
            }
            case 4: {
                return (T)Double.valueOf(value.getDouble());
            }
            case 1: 
            case 7: 
            case 8: {
                return (T)value.getString();
            }
            case 2: {
                return (T)value.getStream();
            }
            case 5: {
                return (T)value.getDate().getTime();
            }
        }
        throw new AssertionError((Object)("Property type " + propertyType + " not handled"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <T> Value get(ValueFactory valueFactory, T o, SimpleType<T> type) throws ValueFormatException {
        SimpleTypeKind typeKind;
        if (type == null) {
            if (o instanceof String) {
                typeKind = SimpleTypeKind.STRING;
            } else if (o instanceof Integer) {
                typeKind = SimpleTypeKind.INT;
            } else if (o instanceof Long) {
                typeKind = SimpleTypeKind.LONG;
            } else if (o instanceof Date) {
                typeKind = SimpleTypeKind.DATE;
            } else if (o instanceof Double) {
                typeKind = SimpleTypeKind.DOUBLE;
            } else if (o instanceof Float) {
                typeKind = SimpleTypeKind.FLOAT;
            } else if (o instanceof InputStream) {
                typeKind = SimpleTypeKind.BINARY;
            } else {
                if (!(o instanceof Boolean)) throw new UnsupportedOperationException("Type " + o.getClass().getName() + " is not accepted");
                typeKind = SimpleTypeKind.BOOLEAN;
            }
        } else {
            typeKind = type.getKind();
        }
        switch (typeKind) {
            case STRING: {
                return valueFactory.createValue((String)o);
            }
            case PATH: {
                return valueFactory.createValue((String)o, 8);
            }
            case LONG: {
                return valueFactory.createValue(((Long)o).longValue());
            }
            case INT: {
                return valueFactory.createValue((long)((Integer)o).intValue());
            }
            case DATE: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)o);
                return valueFactory.createValue(calendar);
            }
            case BINARY: {
                return valueFactory.createValue((InputStream)o);
            }
            case DOUBLE: {
                return valueFactory.createValue(((Double)o).doubleValue());
            }
            case FLOAT: {
                return valueFactory.createValue((double)((Float)o).floatValue());
            }
            case BOOLEAN: {
                return valueFactory.createValue(((Boolean)o).booleanValue());
            }
        }
        throw new UnsupportedOperationException("Simple type " + type + " not accepted");
    }
}

