/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.AdaptingIterator;
import org.chromattic.common.JCR;
import org.chromattic.common.TypeAdapter;
import org.chromattic.core.EntityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyMap
extends AbstractMap<String, Object> {
    private final EntityContext ctx;
    private final SetImpl set = new SetImpl();

    public PropertyMap(EntityContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.set;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.ctx.getPropertyValue((String)key, null);
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String) {
            return this.put((String)key, (Object)null);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object previous = this.ctx.getPropertyValue(key, null);
        this.ctx.setPropertyValue(key, null, value);
        return previous;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetImpl
    extends AbstractSet<Map.Entry<String, Object>> {
        private SetImpl() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            try {
                Iterator i = JCR.adapt((PropertyIterator)((PropertyMap)PropertyMap.this).ctx.state.getNode().getProperties());
                TypeAdapter<Map.Entry<String, Object>, Property> adapter = new TypeAdapter<Map.Entry<String, Object>, Property>(){

                    public Map.Entry<String, Object> adapt(Property property) {
                        try {
                            Object o;
                            switch (property.getType()) {
                                case 1: 
                                case 7: {
                                    o = property.getString();
                                    break;
                                }
                                case 3: {
                                    o = (int)property.getLong();
                                    break;
                                }
                                case 6: {
                                    o = property.getBoolean();
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Should implement handling of property type " + property.getType());
                                }
                            }
                            final String key = property.getName();
                            final Object value = o;
                            return new Map.Entry<String, Object>(){

                                @Override
                                public String getKey() {
                                    return key;
                                }

                                @Override
                                public Object getValue() {
                                    return value;
                                }

                                @Override
                                public Object setValue(Object value2) {
                                    return null;
                                }
                            };
                        }
                        catch (RepositoryException e) {
                            throw new UndeclaredRepositoryException(e);
                        }
                    }
                };
                return new AdaptingIterator(i, (TypeAdapter)adapter);
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }

        @Override
        public int size() {
            try {
                return (int)((PropertyMap)PropertyMap.this).ctx.state.getNode().getProperties().getSize();
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }
    }
}

