/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.BuilderException;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.ObjectInstantiator;
import org.chromattic.common.collection.SetMap;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.mapper.MethodMapper;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.core.mapper.RelatedPropertyMapper;
import org.chromattic.core.mapper.nodeattribute.JCRNodeAttributePropertyMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.AnyChildMultiValueMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.JCRAnyChildCollectionPropertyMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.JCRAnyChildParentPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRNamedReferentPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRReferentCollectionPropertyMapper;
import org.chromattic.core.mapper.onetoone.embedded.JCREmbeddedParentPropertyMapper;
import org.chromattic.core.mapper.onetoone.embedded.JCREmbeddedPropertyMapper;
import org.chromattic.core.mapper.onetoone.hierarchical.JCRNamedChildParentPropertyMapper;
import org.chromattic.core.mapper.onetoone.hierarchical.JCRNamedChildPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyListPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyMapPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyPropertyMapper;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.CollectionPropertyInfo;
import org.chromattic.metamodel.bean.ListPropertyInfo;
import org.chromattic.metamodel.bean.MapPropertyInfo;
import org.chromattic.metamodel.bean.MultiValuedPropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.chromattic.metamodel.mapping.CreateMapping;
import org.chromattic.metamodel.mapping.DestroyMapping;
import org.chromattic.metamodel.mapping.FindByIdMapping;
import org.chromattic.metamodel.mapping.MethodMapping;
import org.chromattic.metamodel.mapping.NodeTypeMapping;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.chromattic.metamodel.mapping.jcr.JCRMemberMapping;
import org.chromattic.metamodel.mapping.jcr.JCRNodeAttributeMapping;
import org.chromattic.metamodel.mapping.jcr.JCRPropertyMapping;
import org.chromattic.metamodel.mapping.value.AbstractManyToOneMapping;
import org.chromattic.metamodel.mapping.value.AbstractOneToManyMapping;
import org.chromattic.metamodel.mapping.value.ManyToOneMapping;
import org.chromattic.metamodel.mapping.value.NamedManyToOneMapping;
import org.chromattic.metamodel.mapping.value.NamedOneToManyMapping;
import org.chromattic.metamodel.mapping.value.NamedOneToOneMapping;
import org.chromattic.metamodel.mapping.value.PropertyMapMapping;
import org.chromattic.metamodel.mapping.value.RelationshipMapping;
import org.chromattic.metamodel.mapping.value.SimpleMapping;
import org.chromattic.metamodel.mapping.value.ValueMapping;
import org.chromattic.spi.instrument.Instrumentor;
import org.chromattic.spi.instrument.MethodHandler;
import org.chromattic.spi.instrument.ProxyFactory;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperBuilder {
    private static final EnumMap<RelationshipType, LinkType> relationshipToLinkMapping;
    private static final ProxyFactory<?> NULL_PROXY_FACTORY;
    private static final Instrumentor NULL_INSTRUMENTOR;
    private final Set<NodeTypeMapping> typeMappings;
    private final Instrumentor instrumentor;
    private final Map<ClassTypeInfo, NodeTypeMapping> classToMapping;
    private SetMap<ClassTypeInfo, RelatedPropertyMapper> relatedProperties = new SetMap();
    private SetMap<ClassTypeInfo, MethodMapper.Create> relatedMethods = new SetMap();

    public MapperBuilder(Set<NodeTypeMapping> typeMappings, Instrumentor instrumentor) {
        HashMap<ClassTypeInfo, NodeTypeMapping> classToMapping = new HashMap<ClassTypeInfo, NodeTypeMapping>();
        for (NodeTypeMapping typeMapping : typeMappings) {
            classToMapping.put(typeMapping.getType(), typeMapping);
        }
        this.typeMappings = typeMappings;
        this.instrumentor = instrumentor;
        this.classToMapping = classToMapping;
    }

    public Collection<ObjectMapper> build() {
        try {
            return this._build();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<ObjectMapper> _build() throws ClassNotFoundException {
        HashMap<String, ObjectMapper> mappers = new HashMap<String, ObjectMapper>();
        for (NodeTypeMapping typeMapping : this.typeMappings) {
            Class contextType = typeMapping.isPrimary() ? EntityContext.class : EmbeddedContext.class;
            ObjectMapper mapper = this.createMapper(contextType, typeMapping);
            mappers.put(typeMapping.getType().getName(), mapper);
        }
        for (ClassTypeInfo relatedType : this.relatedProperties.keySet()) {
            Set properties = this.relatedProperties.get((Object)relatedType);
            HashSet<ObjectMapper> relatedTypes = new HashSet<ObjectMapper>();
            for (ObjectMapper type : mappers.values()) {
                Class<?> relatedClass = Thread.currentThread().getContextClassLoader().loadClass(relatedType.getName());
                if (!relatedClass.isAssignableFrom(type.getObjectClass())) continue;
                relatedTypes.add(type);
            }
            for (RelatedPropertyMapper propertyMapper : properties) {
                propertyMapper.relatedTypes = relatedTypes;
            }
        }
        for (ClassTypeInfo relatedType : this.relatedMethods.keySet()) {
            Set methods = this.relatedMethods.get((Object)relatedType);
            ObjectMapper relatedMapper = (ObjectMapper)mappers.get(relatedType.getName());
            if (relatedMapper == null) {
                throw new IllegalStateException("Could not find mapper for " + relatedType.getName() + " referenced by " + methods);
            }
            for (MethodMapper.Create createMapper : methods) {
                createMapper.type = relatedMapper;
            }
        }
        return new ArrayList<ObjectMapper>(mappers.values());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <C extends ObjectContext> ObjectMapper createMapper(Class<C> contextType, NodeTypeMapping typeMapping) throws ClassNotFoundException {
        ObjectMapper mapper;
        HashSet<MethodMapper> methodMappers = new HashSet<MethodMapper>();
        HashSet<MethodMapper.Destroy> methodMappersForE = new HashSet<MethodMapper.Destroy>();
        HashSet<PropertyMapper> propertyMappers = new HashSet<PropertyMapper>();
        HashSet<PropertyMapper> propertyMappersForE = new HashSet<PropertyMapper>();
        HashSet<JCREmbeddedPropertyMapper> propertyMappersForM = new HashSet<JCREmbeddedPropertyMapper>();
        for (PropertyMapping pm : typeMapping.getPropertyMappings()) {
            ValueMapping pmvm;
            if (pm.getInfo() instanceof SingleValuedPropertyInfo) {
                NamedManyToOneMapping nmtovm;
                LinkType linkType;
                pmvm = pm.getValueMapping();
                SingleValuedPropertyInfo propertyInfo = (SingleValuedPropertyInfo)pm.getInfo();
                if (pmvm instanceof SimpleMapping) {
                    SimpleMapping pmdm = (SimpleMapping)pmvm;
                    JCRMemberMapping jCRMemberMapping = pmdm.getJCRMember();
                    if (jCRMemberMapping instanceof JCRPropertyMapping) {
                        JCRPropertyMapping jCRPropertyMapping = (JCRPropertyMapping)jCRMemberMapping;
                        JCRPropertyPropertyMapper<C> jCRPropertyPropertyMapper = new JCRPropertyPropertyMapper<C>(contextType, (SingleValuedPropertyInfo<SimpleValueInfo>)((SingleValuedPropertyInfo)pm.getInfo()), jCRPropertyMapping.getName(), jCRPropertyMapping.getDefaultValue());
                        propertyMappers.add(jCRPropertyPropertyMapper);
                    } else if (jCRMemberMapping instanceof JCRNodeAttributeMapping) {
                        JCRNodeAttributeMapping jCRNodeAttributeMapping = (JCRNodeAttributeMapping)jCRMemberMapping;
                        JCRNodeAttributePropertyMapper jCRNodeAttributePropertyMapper = new JCRNodeAttributePropertyMapper((SingleValuedPropertyInfo<SimpleValueInfo>)((SingleValuedPropertyInfo)pm.getInfo()), jCRNodeAttributeMapping.getType());
                        if (contextType != EntityContext.class) throw new UnsupportedOperationException("todo");
                        propertyMappersForE.add(jCRNodeAttributePropertyMapper);
                    }
                } else if (pmvm instanceof RelationshipMapping) {
                    RelationshipMapping pmhm = (RelationshipMapping)pmvm;
                    if (pmhm.getType() == RelationshipType.HIERARCHIC) {
                        if (pmhm instanceof ManyToOneMapping) {
                            JCRAnyChildCollectionPropertyMapper jCRAnyChildCollectionPropertyMapper = new JCRAnyChildCollectionPropertyMapper((SingleValuedPropertyInfo<BeanValueInfo>)propertyInfo);
                            this.relatedProperties.get((Object)pmhm.getRelatedMapping().getType()).add(jCRAnyChildCollectionPropertyMapper);
                            propertyMappersForE.add(jCRAnyChildCollectionPropertyMapper);
                        }
                        if (pmhm instanceof NamedOneToOneMapping) {
                            NamedOneToOneMapping namedOneToOneMapping = (NamedOneToOneMapping)pmhm;
                            if (namedOneToOneMapping.isOwning()) {
                                JCRNamedChildParentPropertyMapper<C> jCRNamedChildParentPropertyMapper = new JCRNamedChildParentPropertyMapper<C>(contextType, (SingleValuedPropertyInfo<BeanValueInfo>)propertyInfo, namedOneToOneMapping.getName());
                                this.relatedProperties.get((Object)pmhm.getRelatedMapping().getType()).add(jCRNamedChildParentPropertyMapper);
                                propertyMappers.add(jCRNamedChildParentPropertyMapper);
                            } else {
                                JCRNamedChildPropertyMapper jCRNamedChildPropertyMapper = new JCRNamedChildPropertyMapper((SingleValuedPropertyInfo<BeanValueInfo>)propertyInfo, namedOneToOneMapping.getName());
                                this.relatedProperties.get((Object)namedOneToOneMapping.getRelatedMapping().getType()).add(jCRNamedChildPropertyMapper);
                                propertyMappersForE.add(jCRNamedChildPropertyMapper);
                            }
                        }
                    } else if (pmhm.getType() == RelationshipType.EMBEDDED) {
                        NodeTypeMapping nodeTypeMapping = this.classToMapping.get(((BeanValueInfo)propertyInfo.getValue()).getTypeInfo());
                        if (typeMapping.isPrimary()) {
                            JCREmbeddedParentPropertyMapper jCREmbeddedParentPropertyMapper = new JCREmbeddedParentPropertyMapper((SingleValuedPropertyInfo<BeanValueInfo>)propertyInfo);
                            propertyMappersForE.add(jCREmbeddedParentPropertyMapper);
                        } else {
                            if (!typeMapping.isMixin()) throw new AssertionError();
                            if (!nodeTypeMapping.isPrimary()) throw new BuilderException("Related class in mixin mapping must be annotated with @" + PrimaryType.class.getSimpleName());
                            JCREmbeddedPropertyMapper jCREmbeddedPropertyMapper = new JCREmbeddedPropertyMapper((SingleValuedPropertyInfo<BeanValueInfo>)propertyInfo);
                            propertyMappersForM.add(jCREmbeddedPropertyMapper);
                        }
                    }
                }
                if (!(pmvm instanceof AbstractManyToOneMapping) || !(pmvm instanceof NamedManyToOneMapping) || (linkType = relationshipToLinkMapping.get((nmtovm = (NamedManyToOneMapping)pmvm).getType())) == null) continue;
                JCRNamedReferentPropertyMapper<C> jCRNamedReferentPropertyMapper = new JCRNamedReferentPropertyMapper<C>(contextType, (SingleValuedPropertyInfo<BeanValueInfo>)propertyInfo, nmtovm.getRelatedName(), linkType);
                propertyMappers.add(jCRNamedReferentPropertyMapper);
                this.relatedProperties.get((Object)nmtovm.getRelatedMapping().getType()).add(jCRNamedReferentPropertyMapper);
                continue;
            }
            if (!(pm.getInfo() instanceof MultiValuedPropertyInfo)) continue;
            pmvm = pm.getValueMapping();
            if (pmvm instanceof RelationshipMapping) {
                void var13_23;
                RelationshipMapping pmhm = (RelationshipMapping)pmvm;
                if (!(pmhm instanceof AbstractOneToManyMapping)) continue;
                if (pmhm instanceof NamedOneToManyMapping) {
                    LinkType linkType = relationshipToLinkMapping.get(pmhm.getType());
                    if (linkType == null) continue;
                    NamedOneToManyMapping namedOneToManyMapping = (NamedOneToManyMapping)pmhm;
                    JCRReferentCollectionPropertyMapper jCRReferentCollectionPropertyMapper = new JCRReferentCollectionPropertyMapper((CollectionPropertyInfo<BeanValueInfo>)((CollectionPropertyInfo)pm.getInfo()), namedOneToManyMapping.getName(), linkType);
                    this.relatedProperties.get((Object)pmhm.getRelatedMapping().getType()).add(jCRReferentCollectionPropertyMapper);
                    propertyMappersForE.add(jCRReferentCollectionPropertyMapper);
                    continue;
                }
                if (pmhm.getType() != RelationshipType.HIERARCHIC) continue;
                MultiValuedPropertyInfo mpi = (MultiValuedPropertyInfo)pm.getInfo();
                if (mpi instanceof MapPropertyInfo) {
                    AnyChildMultiValueMapper.Map map = new AnyChildMultiValueMapper.Map();
                } else {
                    if (!(mpi instanceof CollectionPropertyInfo)) throw new IllegalStateException();
                    if (mpi instanceof ListPropertyInfo) {
                        AnyChildMultiValueMapper.List list = new AnyChildMultiValueMapper.List();
                    } else {
                        AnyChildMultiValueMapper.Collection collection = new AnyChildMultiValueMapper.Collection();
                    }
                }
                JCRAnyChildParentPropertyMapper<C> jCRAnyChildParentPropertyMapper = new JCRAnyChildParentPropertyMapper<C>(contextType, (MultiValuedPropertyInfo<BeanValueInfo>)mpi, (AnyChildMultiValueMapper)var13_23);
                this.relatedProperties.get((Object)pmhm.getRelatedMapping().getType()).add(jCRAnyChildParentPropertyMapper);
                propertyMappers.add(jCRAnyChildParentPropertyMapper);
                continue;
            }
            if (pmvm instanceof SimpleMapping) {
                SimpleMapping sm = (SimpleMapping)pmvm;
                JCRMemberMapping jcrMember = sm.getJCRMember();
                if (!(jcrMember instanceof JCRPropertyMapping)) continue;
                JCRPropertyMapping jCRPropertyMapping = (JCRPropertyMapping)jcrMember;
                JCRPropertyListPropertyMapper<C> jCRPropertyListPropertyMapper = new JCRPropertyListPropertyMapper<C>(contextType, (MultiValuedPropertyInfo<SimpleValueInfo>)((MultiValuedPropertyInfo)pm.getInfo()), jCRPropertyMapping.getName());
                propertyMappers.add(jCRPropertyListPropertyMapper);
                continue;
            }
            if (!(pmvm instanceof PropertyMapMapping)) continue;
            JCRPropertyMapPropertyMapper<C> bilto = new JCRPropertyMapPropertyMapper<C>(contextType, (MapPropertyInfo<SimpleValueInfo, SimpleValueInfo>)((MapPropertyInfo)pm.getInfo()));
            propertyMappers.add(bilto);
        }
        for (MethodMapping methodMapping : typeMapping.getMethodMappings()) {
            if (methodMapping instanceof CreateMapping) {
                CreateMapping createMapping = (CreateMapping)methodMapping;
                MethodMapper.Create createMapper = new MethodMapper.Create((Method)createMapping.getMethod().getMethod());
                methodMappers.add(createMapper);
                Set alffl = this.relatedMethods.get((Object)createMapping.getType());
                alffl.add(createMapper);
                continue;
            }
            if (methodMapping instanceof DestroyMapping) {
                MethodMapper.Destroy destroyMapper = new MethodMapper.Destroy((Method)methodMapping.getMethod().getMethod());
                methodMappersForE.add(destroyMapper);
                continue;
            }
            if (!(methodMapping instanceof FindByIdMapping)) throw new UnsupportedOperationException();
            FindByIdMapping findMapping = (FindByIdMapping)methodMapping;
            MethodMapper.FindById findMapper = new MethodMapper.FindById((Method)findMapping.getMethod().getMethod(), findMapping.getType());
            methodMappers.add(findMapper);
        }
        Instrumentor objectInstrumentor = typeMapping.getType().getName().equals(Object.class.getName()) ? NULL_INSTRUMENTOR : this.instrumentor;
        if (typeMapping.isPrimary()) {
            ObjectFormatter formatter = null;
            if (typeMapping.getFormatterClass() != null) {
                formatter = (ObjectFormatter)ObjectInstantiator.newInstance((Class)typeMapping.getFormatterClass());
            }
            HashSet tmp = new HashSet(propertyMappersForE);
            HashSet tmp2 = new HashSet(methodMappersForE);
            if (propertyMappersForM.size() > 0) {
                throw new AssertionError();
            }
            for (PropertyMapper propertyMapper : propertyMappers) {
                tmp.add(propertyMapper);
            }
            for (MethodMapper methodMapper : methodMappers) {
                tmp2.add(methodMapper);
            }
            mapper = new ObjectMapper((Class)typeMapping.getType().getType(), tmp, tmp2, typeMapping.getOnDuplicate(), formatter, objectInstrumentor, typeMapping.getTypeName(), typeMapping.getKind());
        } else {
            if (propertyMappersForE.size() > 0) {
                throw new AssertionError();
            }
            if (methodMappersForE.size() > 0) {
                throw new AssertionError();
            }
            HashSet tmp = new HashSet(propertyMappersForM);
            HashSet tmp2 = new HashSet();
            for (PropertyMapper propertyMapper : propertyMappers) {
                tmp.add(propertyMapper);
            }
            for (MethodMapper methodMapper : methodMappers) {
                tmp2.add(methodMapper);
            }
            mapper = new ObjectMapper((Class)typeMapping.getType().getType(), tmp, tmp2, typeMapping.getOnDuplicate(), null, objectInstrumentor, typeMapping.getTypeName(), typeMapping.getKind());
        }
        for (PropertyMapper pm : propertyMappers) {
            pm.mapper = mapper;
        }
        for (MethodMapper methodMapper : methodMappers) {
            methodMapper.mapper = mapper;
        }
        return mapper;
    }

    static {
        EnumMap<RelationshipType, LinkType> tmp = new EnumMap<RelationshipType, LinkType>(RelationshipType.class);
        tmp.put(RelationshipType.REFERENCE, LinkType.REFERENCE);
        tmp.put(RelationshipType.PATH, LinkType.PATH);
        relationshipToLinkMapping = tmp;
        NULL_PROXY_FACTORY = new ProxyFactory<Object>(){

            public Object createProxy(MethodHandler invoker) {
                throw new UnsupportedOperationException();
            }
        };
        NULL_INSTRUMENTOR = new Instrumentor(){

            public <O> ProxyFactory<O> getProxyClass(Class<O> clazz) {
                return NULL_PROXY_FACTORY;
            }

            public MethodHandler getInvoker(Object proxy) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

