/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.property;

import java.util.List;
import org.chromattic.core.ListType;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.core.vt.ValueType;
import org.chromattic.core.vt.ValueTypeFactory;
import org.chromattic.metamodel.bean.ArrayPropertyInfo;
import org.chromattic.metamodel.bean.ListPropertyInfo;
import org.chromattic.metamodel.bean.MultiValuedPropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRPropertyListPropertyMapper<O extends ObjectContext>
extends PropertyMapper<MultiValuedPropertyInfo<SimpleValueInfo>, O> {
    private final String jcrPropertyName;
    private final ListType listType;
    private final SimpleValueInfo<?> elementType;

    public JCRPropertyListPropertyMapper(Class<O> contextType, MultiValuedPropertyInfo<SimpleValueInfo> info, String jcrPropertyName) {
        super(contextType, info);
        ListType listType;
        if (info instanceof ArrayPropertyInfo) {
            listType = ListType.ARRAY;
        } else if (info instanceof ListPropertyInfo) {
            listType = ListType.LIST;
        } else {
            throw new AssertionError();
        }
        this.listType = listType;
        this.jcrPropertyName = jcrPropertyName;
        this.elementType = (SimpleValueInfo)info.getValue();
    }

    @Override
    public Object get(O context) throws Throwable {
        return this.get(context, this.elementType);
    }

    private <V> Object get(O context, SimpleValueInfo<V> elementType) throws Throwable {
        ValueType<V> vt = ValueTypeFactory.create(elementType, null);
        List<V> list = ((ObjectContext)context).getPropertyValues(this.jcrPropertyName, vt, this.listType);
        return this.listType.unwrap(vt, list);
    }

    @Override
    public void set(O context, Object value) throws Throwable {
        this.set(context, value, this.elementType);
    }

    private <V> void set(O context, Object value, SimpleValueInfo<V> elementType) throws Throwable {
        ValueType<V> vt = ValueTypeFactory.create(elementType, null);
        List<V> list = this.listType.wrap(vt, value);
        ((ObjectContext)context).setPropertyValues(this.jcrPropertyName, vt, this.listType, list);
    }
}

