/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.docs.reference.website;

import java.util.Arrays;
import java.util.Collection;
import org.chromattic.core.api.ChromatticSessionImpl;
import org.chromattic.docs.reference.AbstractTestCase;
import org.chromattic.docs.reference.website.Content;
import org.chromattic.docs.reference.website.Page;
import org.chromattic.docs.reference.website.WebSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalMappingTestCase
extends AbstractTestCase {
    @Override
    protected Iterable<Class<?>> classes() {
        return Arrays.asList(WebSite.class, Page.class, Content.class);
    }

    public void testChildrenCollection() {
        ChromatticSessionImpl session = this.login();
        Page page = (Page)session.insert(Page.class, "foo");
        Page child = (Page)session.create(Page.class, "bar");
        Collection children = page.getChildren();
        children.add(child);
        HierarchicalMappingTestCase.assertSame((Object)page, (Object)child.getParent());
        children.remove(child);
        HierarchicalMappingTestCase.assertFalse((boolean)page.getChildren().contains(child));
    }

    public void testParent() {
        ChromatticSessionImpl session = this.login();
        Page page = (Page)session.insert(Page.class, "foo1");
        Page child = (Page)session.create(Page.class, "bar");
        child.setParent(page);
        HierarchicalMappingTestCase.assertTrue((boolean)page.getChildren().contains(child));
        child.setParent(null);
        HierarchicalMappingTestCase.assertFalse((boolean)page.getChildren().contains(child));
    }

    public void testOneToOne() {
        ChromatticSessionImpl session = this.login();
        WebSite site = (WebSite)session.insert(WebSite.class, "site");
        Page root = (Page)session.create(Page.class);
        site.setRootPage(root);
        HierarchicalMappingTestCase.assertEquals((Object)site, (Object)root.getSite());
        session.save();
        site.setRootPage(null);
    }
}

