/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.Destroy;
import org.chromattic.api.annotations.FindById;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPolicy;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Properties;
import org.chromattic.api.annotations.Property;
import org.chromattic.api.annotations.RelatedMappedBy;
import org.chromattic.api.annotations.WorkspaceName;
import org.chromattic.metamodel.bean.AnnotatedProperty;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanInfoFactory;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.MapPropertyInfo;
import org.chromattic.metamodel.bean.MultiValuedPropertyInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleType;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.chromattic.metamodel.bean.ValueInfo;
import org.chromattic.metamodel.mapping.CreateMapping;
import org.chromattic.metamodel.mapping.DestroyMapping;
import org.chromattic.metamodel.mapping.FindByIdMapping;
import org.chromattic.metamodel.mapping.InvalidMappingException;
import org.chromattic.metamodel.mapping.JLOTypeInfo;
import org.chromattic.metamodel.mapping.MethodMapping;
import org.chromattic.metamodel.mapping.NodeAttributeType;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.mapping.NodeTypeMapping;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.chromattic.metamodel.mapping.jcr.JCRNodeAttributeMapping;
import org.chromattic.metamodel.mapping.jcr.JCRPropertyMapping;
import org.chromattic.metamodel.mapping.value.AbstractOneToManyMapping;
import org.chromattic.metamodel.mapping.value.ManyToOneMapping;
import org.chromattic.metamodel.mapping.value.NamedManyToOneMapping;
import org.chromattic.metamodel.mapping.value.NamedOneToManyMapping;
import org.chromattic.metamodel.mapping.value.NamedOneToOneMapping;
import org.chromattic.metamodel.mapping.value.OneToManyMapping;
import org.chromattic.metamodel.mapping.value.OneToOneMapping;
import org.chromattic.metamodel.mapping.value.PropertyMapMapping;
import org.chromattic.metamodel.mapping.value.SimpleMapping;
import org.chromattic.metamodel.mapping.value.ValueMapping;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.introspection.AnnotationIntrospector;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMappingDomain {
    private final boolean processFormatter;
    private final Map<String, NodeTypeMapping> mappings = new HashMap<String, NodeTypeMapping>();
    private final Set<ClassTypeInfo> types;
    private final BeanInfoFactory beanInfoBuilder = new BeanInfoFactory();
    private boolean resolved;

    public TypeMappingDomain(boolean processFormatter) {
        this.processFormatter = processFormatter;
        this.types = new HashSet<ClassTypeInfo>();
        this.resolved = false;
    }

    public NodeTypeMapping get(ClassTypeInfo type) {
        return this.mappings.get(type.getName());
    }

    public void add(ClassTypeInfo javaClass) {
        this.types.add(javaClass);
        this.resolved = false;
    }

    public Collection<NodeTypeMapping> build() {
        this.resolve();
        return this.mappings.values();
    }

    public void resolve() {
        if (!this.resolved) {
            HashMap<String, NodeTypeMapping> addedMappings = new HashMap<String, NodeTypeMapping>();
            this.resolve(JLOTypeInfo.get(), addedMappings);
            for (ClassTypeInfo cti : this.types) {
                if (cti.getName().equals(Object.class.getName())) continue;
                try {
                    this.resolve(cti, addedMappings);
                }
                catch (Exception e) {
                    InvalidMappingException ime;
                    if (e instanceof InvalidMappingException && (ime = (InvalidMappingException)((Object)e)).getType().equals(cti)) {
                        throw ime;
                    }
                    throw new InvalidMappingException(cti, (Throwable)e);
                }
            }
            addedMappings.remove(Object.class.getName());
            this.mappings.clear();
            this.mappings.putAll(addedMappings);
        }
    }

    private static <V> JCRPropertyMapping<V> createProperty(String name, SimpleType<V> type, String[] defaultValue) {
        List<V> defaultValueList = null;
        if (defaultValue.length > 0) {
            defaultValueList = new ArrayList(defaultValue.length);
            for (String value : defaultValue) {
                V v = type.toExternal(value);
                defaultValueList.add(v);
            }
            defaultValueList = Collections.unmodifiableList(defaultValueList);
        }
        return new JCRPropertyMapping(name, defaultValueList);
    }

    private NodeTypeMapping resolve(ClassTypeInfo javaClass, Map<String, NodeTypeMapping> addedMappings) {
        ClassTypeInfo argCTI;
        TypeInfo argTI;
        List parameterTypes;
        NodeTypeMapping relatedMapping;
        AnnotatedProperty<MappedBy> mappedBy;
        RelationshipType type;
        BeanValueInfo bvi;
        PropertyInfo<?> propertyInfo;
        PrimaryType primaryType;
        if (javaClass.getName().equals(Object.class.getName())) {
            NodeTypeMapping objectMapping = new NodeTypeMapping(this, javaClass, Collections.<PropertyMapping<ValueMapping>>emptySet(), Collections.<MethodMapping>emptySet(), NameConflictResolution.FAIL, "nt:base", null, NodeTypeKind.PRIMARY, false);
            addedMappings.put(javaClass.getName(), objectMapping);
            return objectMapping;
        }
        NodeTypeMapping nodeTypeMapping = addedMappings.get(javaClass.getName());
        if (nodeTypeMapping != null) {
            return nodeTypeMapping;
        }
        HashSet<PropertyMapping<? extends ValueMapping>> propertyMappings = new HashSet<PropertyMapping<? extends ValueMapping>>();
        HashSet<MethodMapping> methodMappings = new HashSet<MethodMapping>();
        BeanInfo info = this.beanInfoBuilder.build(javaClass);
        NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
        NamingPolicy namingPolicy = (NamingPolicy)new AnnotationIntrospector(NamingPolicy.class).resolve(javaClass);
        if (namingPolicy != null) {
            onDuplicate = namingPolicy.onDuplicate();
        }
        if ((primaryType = (PrimaryType)javaClass.getDeclaredAnnotation(PrimaryType.class)) == null) {
            MixinType mixinType = (MixinType)javaClass.getDeclaredAnnotation(MixinType.class);
            if (mixinType == null) {
                throw new InvalidMappingException(javaClass, "Class is not annotated");
            }
            String string = mixinType != null ? mixinType.name() : null;
            nodeTypeMapping = NodeTypeMapping.createMixinType(this, javaClass, propertyMappings, methodMappings, onDuplicate, string, false);
        } else {
            String nodeTypeName = primaryType.name();
            boolean bl = primaryType.orderable();
            Class formatter = null;
            if (this.processFormatter) {
                FormattedBy formattedBy = info.getAnnotation(FormattedBy.class);
                formatter = formattedBy != null ? formattedBy.value() : null;
            }
            nodeTypeMapping = NodeTypeMapping.createPrimaryType(this, javaClass, propertyMappings, methodMappings, onDuplicate, nodeTypeName, formatter, bl);
        }
        addedMappings.put(javaClass.getName(), nodeTypeMapping);
        for (AnnotatedProperty<Property> annotatedProperty : info.findAnnotatedProperties(Property.class)) {
            Object value;
            Property propertyAnnotation = (Property)annotatedProperty.getAnnotation();
            PropertyInfo<?> propertyInfo2 = annotatedProperty.getProperty();
            if (propertyInfo2 instanceof SingleValuedPropertyInfo) {
                SingleValuedPropertyInfo svp = (SingleValuedPropertyInfo)propertyInfo2;
                value = svp.getValue();
            } else if (propertyInfo2 instanceof MultiValuedPropertyInfo) {
                MultiValuedPropertyInfo mvp = (MultiValuedPropertyInfo)propertyInfo2;
                value = mvp.getValue();
            } else {
                throw new IllegalStateException();
            }
            if (!(value instanceof SimpleValueInfo)) {
                throw new InvalidMappingException(javaClass, "Cannot map property type " + value);
            }
            SimpleValueInfo simpleValue = (SimpleValueInfo)value;
            String[] defaultValues = propertyAnnotation.defaultValue();
            SimpleType simpleType = simpleValue.getSimpleType();
            JCRPropertyMapping memberMapping = TypeMappingDomain.createProperty(propertyAnnotation.name(), simpleType, defaultValues);
            SimpleMapping simpleMapping = new SimpleMapping(annotatedProperty.getOwner(), memberMapping);
            PropertyMapping propertyMapping = new PropertyMapping(propertyInfo2, simpleMapping);
            propertyMappings.add(propertyMapping);
        }
        for (AnnotatedProperty<Property> annotatedProperty : info.findAnnotatedProperties(Properties.class)) {
            propertyInfo = annotatedProperty.getProperty();
            if (propertyInfo instanceof MapPropertyInfo) {
                MapPropertyInfo mapPropertyInfo = (MapPropertyInfo)propertyInfo;
                PropertyMapMapping simpleMapping = new PropertyMapMapping(annotatedProperty.getOwner());
                PropertyMapping<PropertyMapMapping> propertyMapping = new PropertyMapping<PropertyMapMapping>(mapPropertyInfo, simpleMapping);
                propertyMappings.add(propertyMapping);
                continue;
            }
            throw new IllegalStateException();
        }
        for (PropertyInfo propertyInfo2 : info.getProperties()) {
            NodeAttributeType nat;
            Collection<AnnotatedProperty<?>> annotations = propertyInfo2.getAnnotateds(Name.class, Id.class, Path.class, WorkspaceName.class);
            if (annotations.size() <= 0) continue;
            if (annotations.size() > 1) {
                throw new InvalidMappingException(javaClass, "Too many annotations of the same kind " + annotations);
            }
            AnnotatedProperty<?> annotated = annotations.iterator().next();
            Object annotation = annotated.getAnnotation();
            if (annotation instanceof Name) {
                nat = NodeAttributeType.NAME;
            } else if (annotation instanceof Id) {
                nat = NodeAttributeType.ID;
            } else if (annotation instanceof Path) {
                nat = NodeAttributeType.PATH;
            } else if (annotation instanceof WorkspaceName) {
                nat = NodeAttributeType.WORKSPACE_NAME;
            } else {
                throw new AssertionError();
            }
            if (propertyInfo2 instanceof SingleValuedPropertyInfo) {
                SingleValuedPropertyInfo svpi = (SingleValuedPropertyInfo)propertyInfo2;
                Object vi = svpi.getValue();
                if (vi instanceof SimpleValueInfo) {
                    SimpleValueInfo svi = (SimpleValueInfo)vi;
                    JCRNodeAttributeMapping memberMapping = new JCRNodeAttributeMapping(nat);
                    SimpleType simpleType = svi.getSimpleType();
                    if (nat == NodeAttributeType.PATH) {
                        if (simpleType != SimpleType.PATH) {
                            throw new IllegalStateException("Type " + simpleType + " is not accepted for path attribute mapping");
                        }
                    } else if (simpleType != SimpleType.STRING) {
                        throw new IllegalStateException("Type " + simpleType + " is not accepted for attribute mapping");
                    }
                    SimpleMapping<JCRNodeAttributeMapping> simpleMapping = new SimpleMapping<JCRNodeAttributeMapping>(annotated.getOwner(), memberMapping);
                    PropertyMapping<SimpleMapping<JCRNodeAttributeMapping>> propertyMapping = new PropertyMapping<SimpleMapping<JCRNodeAttributeMapping>>(propertyInfo2, simpleMapping);
                    propertyMappings.add(propertyMapping);
                    continue;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        for (AnnotatedProperty annotatedProperty : info.findAnnotatedProperties(OneToOne.class)) {
            propertyInfo = annotatedProperty.getProperty();
            OneToOne oneToOneAnn = (OneToOne)annotatedProperty.getAnnotation();
            if (propertyInfo instanceof SingleValuedPropertyInfo) {
                SingleValuedPropertyInfo svpi = (SingleValuedPropertyInfo)propertyInfo;
                Object vi = svpi.getValue();
                if (vi instanceof BeanValueInfo) {
                    BeanValueInfo bvi2 = (BeanValueInfo)vi;
                    ClassTypeInfo typeInfo = bvi2.getTypeInfo();
                    RelationshipType type2 = oneToOneAnn.type();
                    if (type2 == RelationshipType.HIERARCHIC) {
                        NamedOneToOneMapping hierarchyMapping;
                        AnnotatedProperty<MappedBy> mappedBy2 = propertyInfo.getAnnotated(MappedBy.class);
                        if (mappedBy2 != null) {
                            NodeTypeMapping relatedMapping2 = this.resolve(typeInfo, addedMappings);
                            hierarchyMapping = new NamedOneToOneMapping(annotatedProperty.getOwner(), nodeTypeMapping, relatedMapping2, ((MappedBy)mappedBy2.getAnnotation()).value(), RelationshipType.HIERARCHIC, true);
                        } else {
                            AnnotatedProperty<RelatedMappedBy> relatedMappedBy = propertyInfo.getAnnotated(RelatedMappedBy.class);
                            if (relatedMappedBy != null) {
                                NodeTypeMapping relatedMapping3 = this.resolve(typeInfo, addedMappings);
                                hierarchyMapping = new NamedOneToOneMapping(annotatedProperty.getOwner(), nodeTypeMapping, relatedMapping3, ((RelatedMappedBy)relatedMappedBy.getAnnotation()).value(), RelationshipType.HIERARCHIC, false);
                            } else {
                                throw new IllegalStateException("No related by mapping found for property " + propertyInfo + " when introspecting " + info);
                            }
                        }
                        PropertyMapping<NamedOneToOneMapping> oneToOneMapping = new PropertyMapping<NamedOneToOneMapping>(propertyInfo, hierarchyMapping);
                        propertyMappings.add(oneToOneMapping);
                        continue;
                    }
                    if (type2 == RelationshipType.EMBEDDED) {
                        NodeTypeMapping relatedMapping4 = this.resolve(typeInfo, addedMappings);
                        OneToOneMapping embeddedMapping = new OneToOneMapping(annotatedProperty.getOwner(), nodeTypeMapping, relatedMapping4, RelationshipType.EMBEDDED);
                        PropertyMapping<OneToOneMapping> a = new PropertyMapping<OneToOneMapping>(propertyInfo, embeddedMapping);
                        propertyMappings.add(a);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        for (AnnotatedProperty annotatedProperty : info.findAnnotatedProperties(OneToMany.class)) {
            PropertyMapping<OneToManyMapping> oneToManyMapping;
            AbstractOneToManyMapping mapping;
            Object beanElementType;
            propertyInfo = annotatedProperty.getProperty();
            if (!(propertyInfo instanceof MultiValuedPropertyInfo)) continue;
            MultiValuedPropertyInfo multiValuedProperty = (MultiValuedPropertyInfo)propertyInfo;
            if (multiValuedProperty instanceof MapPropertyInfo) {
                MapPropertyInfo mapProperty = (MapPropertyInfo)multiValuedProperty;
                if (!(mapProperty.getKeyValue() instanceof SimpleValueInfo)) {
                    throw new IllegalStateException("Wrong key value type " + mapProperty.getKeyValue());
                }
                SimpleValueInfo svi = (SimpleValueInfo)mapProperty.getKeyValue();
                if (svi.getSimpleType() != SimpleType.STRING) {
                    throw new IllegalStateException();
                }
            }
            if (!((beanElementType = multiValuedProperty.getValue()) instanceof BeanValueInfo)) continue;
            bvi = (BeanValueInfo)beanElementType;
            type = ((OneToMany)annotatedProperty.getAnnotation()).type();
            if (type == RelationshipType.HIERARCHIC) {
                mappedBy = propertyInfo.getAnnotated(MappedBy.class);
                if (mappedBy != null) {
                    throw new IllegalStateException();
                }
                relatedMapping = this.resolve(bvi.getTypeInfo(), addedMappings);
                mapping = new OneToManyMapping(annotatedProperty.getOwner(), nodeTypeMapping, relatedMapping, RelationshipType.HIERARCHIC);
                oneToManyMapping = new PropertyMapping<OneToManyMapping>((PropertyInfo<ValueInfo>)propertyInfo, (OneToManyMapping)mapping);
                propertyMappings.add(oneToManyMapping);
                continue;
            }
            mappedBy = propertyInfo.getAnnotated(RelatedMappedBy.class);
            if (mappedBy == null) {
                throw new IllegalStateException();
            }
            relatedMapping = this.resolve(bvi.getTypeInfo(), addedMappings);
            mapping = new NamedOneToManyMapping(annotatedProperty.getOwner(), nodeTypeMapping, relatedMapping, ((RelatedMappedBy)mappedBy.getAnnotation()).value(), type);
            oneToManyMapping = new PropertyMapping<OneToManyMapping>((PropertyInfo<ValueInfo>)propertyInfo, (OneToManyMapping)mapping);
            propertyMappings.add(oneToManyMapping);
        }
        for (AnnotatedProperty annotatedProperty : info.findAnnotatedProperties(ManyToOne.class)) {
            propertyInfo = annotatedProperty.getProperty();
            if (propertyInfo instanceof SingleValuedPropertyInfo) {
                SingleValuedPropertyInfo svpi = (SingleValuedPropertyInfo)propertyInfo;
                Object vi = svpi.getValue();
                if (vi instanceof BeanValueInfo) {
                    bvi = (BeanValueInfo)vi;
                    type = ((ManyToOne)annotatedProperty.getAnnotation()).type();
                    if (type == RelationshipType.HIERARCHIC) {
                        NodeTypeMapping relatedMapping5 = this.resolve(bvi.getTypeInfo(), addedMappings);
                        ManyToOneMapping hierarchyMapping = new ManyToOneMapping(annotatedProperty.getOwner(), nodeTypeMapping, relatedMapping5, RelationshipType.HIERARCHIC);
                        PropertyMapping<ManyToOneMapping> manyToOneMapping = new PropertyMapping<ManyToOneMapping>(propertyInfo, hierarchyMapping);
                        propertyMappings.add(manyToOneMapping);
                        continue;
                    }
                    mappedBy = propertyInfo.getAnnotated(MappedBy.class);
                    if (mappedBy == null) {
                        throw new IllegalStateException();
                    }
                    relatedMapping = this.resolve(bvi.getTypeInfo(), addedMappings);
                    NamedManyToOneMapping referenceMapping = new NamedManyToOneMapping(annotatedProperty.getOwner(), nodeTypeMapping, relatedMapping, ((MappedBy)mappedBy.getAnnotation()).value(), type);
                    PropertyMapping<NamedManyToOneMapping> manyToOneMapping = new PropertyMapping<NamedManyToOneMapping>(propertyInfo, referenceMapping);
                    propertyMappings.add(manyToOneMapping);
                    continue;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        MethodIntrospector introspector = new MethodIntrospector(HierarchyScope.ALL);
        for (MethodInfo method : introspector.resolveMethods(javaClass, Create.class)) {
            if (method.isStatic()) continue;
            parameterTypes = method.getParameterTypes();
            if (parameterTypes.size() < 2) {
                if (parameterTypes.size() == 1) {
                    argTI = (TypeInfo)parameterTypes.get(0);
                    if (argTI instanceof ClassTypeInfo) {
                        argCTI = (ClassTypeInfo)argTI;
                        if (!argCTI.getName().equals(String.class.getName())) {
                            throw new IllegalStateException();
                        }
                    } else {
                        throw new IllegalStateException();
                    }
                }
                ClassTypeInfo cti = (ClassTypeInfo)javaClass.resolve(method.getReturnType());
                methodMappings.add(new CreateMapping(method, cti));
                continue;
            }
            throw new IllegalStateException();
        }
        for (MethodInfo method : introspector.resolveMethods(javaClass, Destroy.class)) {
            if (method.isStatic()) continue;
            parameterTypes = method.getParameterTypes();
            if (parameterTypes.size() != 0) {
                throw new IllegalStateException();
            }
            if (!(method.getReturnType() instanceof VoidTypeInfo)) {
                throw new IllegalStateException();
            }
            methodMappings.add(new DestroyMapping(method));
        }
        for (MethodInfo method : introspector.resolveMethods(javaClass, FindById.class)) {
            if (method.isStatic() || (parameterTypes = method.getParameterTypes()).size() != 1) continue;
            argTI = (TypeInfo)parameterTypes.get(0);
            if (argTI instanceof ClassTypeInfo) {
                argCTI = (ClassTypeInfo)argTI;
                if (argCTI.getName().equals(String.class.getName())) {
                    ClassTypeInfo cti = (ClassTypeInfo)javaClass.resolve(method.getReturnType());
                    methodMappings.add(new FindByIdMapping(method, cti));
                    continue;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        this.mappings.put(javaClass.getName(), nodeTypeMapping);
        return nodeTypeMapping;
    }
}

