/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.mapping;

import java.util.Collections;
import java.util.Set;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.metamodel.mapping.MethodMapping;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.chromattic.metamodel.mapping.TypeMappingDomain;
import org.chromattic.metamodel.mapping.value.ValueMapping;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeMapping {
    private final TypeMappingDomain domain;
    private final String typeName;
    protected final ClassTypeInfo type;
    private final Set<PropertyMapping<? extends ValueMapping>> propertyMappings;
    private final Set<MethodMapping> methodMappings;
    private final NameConflictResolution onDuplicate;
    private Class<? extends ObjectFormatter> formatterClass;
    private final NodeTypeKind kind;
    private final boolean orderable;

    public static NodeTypeMapping createMixinType(TypeMappingDomain domain, ClassTypeInfo objectClass, Set<PropertyMapping<? extends ValueMapping>> propertyMappings, Set<MethodMapping> methodMappings, NameConflictResolution onDuplicate, String mixinTypeName, boolean orderable) {
        return new NodeTypeMapping(domain, objectClass, propertyMappings, methodMappings, onDuplicate, mixinTypeName, null, NodeTypeKind.MIXIN, orderable);
    }

    public static NodeTypeMapping createPrimaryType(TypeMappingDomain domain, ClassTypeInfo objectClass, Set<PropertyMapping<? extends ValueMapping>> propertyMappings, Set<MethodMapping> methodMappings, NameConflictResolution onDuplicate, String nodeTypeName, Class<? extends ObjectFormatter> formatterClass, boolean orderable) {
        return new NodeTypeMapping(domain, objectClass, propertyMappings, methodMappings, onDuplicate, nodeTypeName, formatterClass, NodeTypeKind.PRIMARY, orderable);
    }

    public NodeTypeMapping(TypeMappingDomain domain, ClassTypeInfo type, Set<PropertyMapping<? extends ValueMapping>> propertyMappings, Set<MethodMapping> methodMappings, NameConflictResolution onDuplicate, String typeName, Class<? extends ObjectFormatter> formatterClass, NodeTypeKind kind, boolean orderable) {
        this.domain = domain;
        this.type = type;
        this.propertyMappings = Collections.unmodifiableSet(propertyMappings);
        this.methodMappings = Collections.unmodifiableSet(methodMappings);
        this.onDuplicate = onDuplicate;
        this.formatterClass = formatterClass;
        this.typeName = typeName;
        this.kind = kind;
        this.orderable = orderable;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public TypeMappingDomain getDomain() {
        return this.domain;
    }

    public boolean isPrimary() {
        return this.kind == NodeTypeKind.PRIMARY;
    }

    public boolean isMixin() {
        return this.kind == NodeTypeKind.MIXIN;
    }

    public NodeTypeKind getKind() {
        return this.kind;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ClassTypeInfo getType() {
        return this.type;
    }

    public Class<? extends ObjectFormatter> getFormatterClass() {
        return this.formatterClass;
    }

    public Set<PropertyMapping<? extends ValueMapping>> getPropertyMappings() {
        return this.propertyMappings;
    }

    public Set<MethodMapping> getMethodMappings() {
        return this.methodMappings;
    }

    public NameConflictResolution getOnDuplicate() {
        return this.onDuplicate;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeTypeMapping) {
            NodeTypeMapping that = (NodeTypeMapping)obj;
            return this.type.equals(that.type);
        }
        return false;
    }

    public String toString() {
        return "NodeTypeMapping[type=" + this.type + "]";
    }
}

