/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.chromattic.metamodel.bean.AccessMode;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanInfoBuilder;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.chromattic.metamodel.bean.ValueInfo;
import org.chromattic.metamodel.type.SimpleTypeResolver;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.JavaLangReflectReflectionModel;
import org.reflext.spi.model.ReflectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanTestCase
extends TestCase {
    protected final TypeResolver<Type> domain = TypeResolverImpl.create((ReflectionModel)JavaLangReflectReflectionModel.getInstance());

    protected final BeanInfo beanInfo(ClassTypeInfo typeInfo) {
        return (BeanInfo)new BeanInfoBuilder(new SimpleTypeResolver()).build(new ClassTypeInfo[]{typeInfo}).get(typeInfo);
    }

    protected final void assertProperty(PropertyInfo<?> property, String expectedName, Class<?> expectedType, AccessMode accessMode) {
        AbstractBeanTestCase.assertNotNull(property);
        AbstractBeanTestCase.assertEquals((String)expectedName, (String)property.getName());
        ValueInfo value = property.getValue();
        if (property instanceof SingleValuedPropertyInfo) {
            AbstractBeanTestCase.assertEquals((String)expectedType.getName(), (String)value.getEffectiveType().getName());
            switch (accessMode) {
                case READ_ONLY: {
                    AbstractBeanTestCase.assertNotNull((Object)property.getGetter());
                    AbstractBeanTestCase.assertNull((Object)property.getSetter());
                    break;
                }
                case WRITE_ONLY: {
                    AbstractBeanTestCase.assertNull((Object)property.getGetter());
                    AbstractBeanTestCase.assertNotNull((Object)property.getSetter());
                    break;
                }
                case READ_WRITE: {
                    AbstractBeanTestCase.assertNotNull((Object)property.getGetter());
                    AbstractBeanTestCase.assertNotNull((Object)property.getSetter());
                }
            }
        } else {
            AbstractBeanTestCase.fail((String)"todo");
        }
    }

    protected final <A extends Annotation> void assertAnnotation(PropertyInfo<?> property, Class<A> annotationClass, Map<String, Object> expectedAnnotation) {
        Annotation ann1 = property.getAnnotation(annotationClass);
        AbstractBeanTestCase.assertNotNull((Object)ann1);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Method m : ann1.getClass().getDeclaredMethods()) {
            if (m.getName().equals("equals") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == Object.class || m.getName().equals("hashCode") && m.getParameterTypes().length == 0 || m.getName().equals("toString") && m.getParameterTypes().length == 0 || m.getName().equals("annotationType") && m.getParameterTypes().length == 0) continue;
            try {
                Object value = m.invoke((Object)ann1, new Object[0]);
                values.put(m.getName(), value);
            }
            catch (Exception e) {
                AssertionFailedError afe = new AssertionFailedError("Could not invoke annotation value " + m);
                afe.initCause((Throwable)e);
                throw afe;
            }
        }
        AbstractBeanTestCase.assertEquals(expectedAnnotation, values);
    }
}

