/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen.inheritance;

import java.util.Map;
import org.chromattic.metamodel.typegen.AbstractSchemaTestCase;
import org.chromattic.metamodel.typegen.NodeDefinition;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.inheritance.A1;
import org.chromattic.metamodel.typegen.inheritance.A3;
import org.chromattic.metamodel.typegen.inheritance.A4;
import org.chromattic.metamodel.typegen.inheritance.A5;
import org.chromattic.metamodel.typegen.inheritance.D2;
import org.chromattic.metamodel.typegen.inheritance.E2;
import org.chromattic.metamodel.typegen.inheritance.F2;
import org.chromattic.metamodel.typegen.inheritance.G1;
import org.chromattic.metamodel.typegen.inheritance.G2;
import org.chromattic.metamodel.typegen.inheritance.G3;
import org.chromattic.metamodel.typegen.inheritance.H1;
import org.chromattic.metamodel.typegen.inheritance.H2;
import org.chromattic.metamodel.typegen.inheritance.H3;
import org.chromattic.metamodel.typegen.inheritance.I1;
import org.chromattic.metamodel.typegen.inheritance.I2;
import org.chromattic.metamodel.typegen.inheritance.I3;
import org.chromattic.metamodel.typegen.inheritance.I4;

public class InheritanceTestCase
extends AbstractSchemaTestCase {
    private NodeType a1NT;
    private NodeType a3NT;
    private NodeType a4NT;
    private NodeType a5NT;

    protected void setUp() throws Exception {
        Map<Class<?>, NodeType> a = this.assertValid(A1.class, A3.class, A4.class, A5.class);
        this.a1NT = a.get(A1.class);
        this.a3NT = a.get(A3.class);
        this.a4NT = a.get(A4.class);
        this.a5NT = a.get(A5.class);
    }

    public void testSuperTypes() throws Exception {
        InheritanceTestCase.assertEquals((int)1, (int)this.a1NT.getSuperTypes().size());
        InheritanceTestCase.assertEquals((int)2, (int)this.a3NT.getSuperTypes().size());
        InheritanceTestCase.assertEquals((int)2, (int)this.a5NT.getSuperTypes().size());
        InheritanceTestCase.assertTrue((boolean)this.a3NT.getSuperTypes().contains(this.a1NT));
        InheritanceTestCase.assertTrue((boolean)this.a5NT.getSuperTypes().contains(this.a1NT));
        InheritanceTestCase.assertEquals((int)3, (int)this.a4NT.getSuperTypes().size());
        InheritanceTestCase.assertTrue((boolean)this.a4NT.getSuperTypes().contains(this.a1NT));
        InheritanceTestCase.assertTrue((boolean)this.a4NT.getSuperTypes().contains(this.a3NT));
    }

    public void testDeclaredSuperTypes() throws Exception {
        InheritanceTestCase.assertEquals((int)1, (int)this.a1NT.getDeclaredSuperTypes().size());
        InheritanceTestCase.assertEquals((int)1, (int)this.a3NT.getDeclaredSuperTypes().size());
        InheritanceTestCase.assertEquals((int)1, (int)this.a5NT.getDeclaredSuperTypes().size());
        InheritanceTestCase.assertTrue((boolean)this.a3NT.getDeclaredSuperTypes().contains(this.a1NT));
        InheritanceTestCase.assertTrue((boolean)this.a5NT.getDeclaredSuperTypes().contains(this.a1NT));
        InheritanceTestCase.assertEquals((int)1, (int)this.a4NT.getDeclaredSuperTypes().size());
        InheritanceTestCase.assertTrue((boolean)this.a4NT.getDeclaredSuperTypes().contains(this.a3NT));
    }

    public void testProperty() throws Exception {
        InheritanceTestCase.assertEquals((int)1, (int)this.a1NT.getPropertyDefinitions().size());
        InheritanceTestCase.assertEquals((int)0, (int)this.a3NT.getPropertyDefinitions().size());
        InheritanceTestCase.assertEquals((int)0, (int)this.a5NT.getPropertyDefinitions().size());
    }

    public void testChildNodeDefinitions() throws Exception {
        InheritanceTestCase.assertTrue((boolean)true);
        InheritanceTestCase.assertEquals((int)2, (int)this.a1NT.getChildNodeDefinitions().size());
        InheritanceTestCase.assertEquals((int)0, (int)this.a3NT.getChildNodeDefinitions().size());
        InheritanceTestCase.assertEquals((int)2, (int)this.a5NT.getChildNodeDefinitions().size());
    }

    public void testRelationshipOverride() {
        Map<Class<?>, NodeType> a = this.assertValid(G1.class, G2.class, G3.class);
        NodeType g1 = a.get(H1.class);
        NodeType g2 = a.get(H2.class);
        NodeType g3 = a.get(H3.class);
    }

    public void testGenericRelationship() {
        Map<Class<?>, NodeType> a = this.assertValid(H1.class, H2.class, H3.class);
        NodeType h1 = a.get(H1.class);
        NodeType h2 = a.get(H2.class);
        NodeType h3 = a.get(H3.class);
        NodeDefinition h1AnyDef = h1.getChildNodeDefinition("*");
        InheritanceTestCase.assertNotNull((Object)h1AnyDef);
        InheritanceTestCase.assertEquals((String)"nt:base", (String)h1AnyDef.getNodeTypeName());
        NodeDefinition h2AnyDef = h2.getChildNodeDefinition("*");
        InheritanceTestCase.assertNotNull((Object)h2AnyDef);
        InheritanceTestCase.assertEquals((String)"h3", (String)h2AnyDef.getNodeTypeName());
    }

    public void testOneToOneGenericRelationship() {
        Map<Class<?>, NodeType> a = this.assertValid(I1.class, I2.class, I3.class, I4.class);
        NodeType i1 = a.get(I1.class);
        NodeType i2 = a.get(I2.class);
        NodeType i3 = a.get(I3.class);
        NodeType i4 = a.get(I4.class);
        NodeDefinition i1ChildDef = i1.getChildNodeDefinition("child");
        InheritanceTestCase.assertNotNull((Object)i1ChildDef);
        InheritanceTestCase.assertEquals((String)"i3", (String)i1ChildDef.getNodeTypeName());
        NodeDefinition i2ChildDef = i2.getChildNodeDefinition("child");
        InheritanceTestCase.assertNotNull((Object)i2ChildDef);
        InheritanceTestCase.assertEquals((String)"i4", (String)i2ChildDef.getNodeTypeName());
    }

    public void testInvalidAbstractOwnerOneToOne() {
        this.assertInvalid(D2.class);
    }

    public void testInvalidAbstractOneToOne() {
        this.assertInvalid(E2.class);
    }

    public void testInvalidAbstractOneToMany() {
        this.assertInvalid(F2.class);
    }
}

