/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.chromattic.metamodel.bean.AccessMode;
import org.chromattic.metamodel.bean.BeanTestCase;
import org.chromattic.metamodel.bean.PropertyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanTestCase
extends TestCase {
    protected abstract Collection<PropertyMetaData> buildMetaData(Class<?> var1) throws Exception;

    protected final void assertProperties(Class<?> beanClass, PropertyMetaData ... descriptors) throws Exception {
        HashMap<String, PropertyMetaData> actual = new HashMap<String, PropertyMetaData>();
        for (PropertyMetaData propertyMD : this.buildMetaData(beanClass)) {
            actual.put(propertyMD.name, propertyMD);
        }
        HashMap<String, PropertyMetaData> expected = new HashMap<String, PropertyMetaData>();
        for (PropertyMetaData propertyMD : descriptors) {
            expected.put(propertyMD.name, propertyMD);
        }
        BeanTestCase.assertEquals(expected, actual);
    }

    public void testReadOnlyProperty() throws Exception {
        class A {
            A() {
            }

            public String getA() {
                return null;
            }
        }
        this.assertProperties(A.class, new PropertyMetaData("a", String.class, AccessMode.READ_ONLY));
    }

    public void testWriteOnlyProperty() throws Exception {
        class A {
            A() {
            }

            public void setA(String a) {
            }
        }
        this.assertProperties(A.class, new PropertyMetaData("a", String.class, AccessMode.WRITE_ONLY));
    }

    public void testReadWriteProperty() throws Exception {
        class A {
            A() {
            }

            public String getA() {
                return null;
            }

            public void setA(String a) {
            }
        }
        this.assertProperties(A.class, new PropertyMetaData("a", String.class, AccessMode.READ_WRITE));
    }

    public void testGetterInheritance() throws Exception {
        class B
        extends 4A {
            B() {
                class A {
                    final /* synthetic */ BeanTestCase this$0;

                    A(BeanTestCase beanTestCase) {
                        this.this$0 = beanTestCase;
                    }

                    public String getA() {
                        return null;
                    }
                }
                super(BeanTestCase.this);
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", String.class, AccessMode.READ_ONLY));
    }

    public void testSetterInheritance() throws Exception {
        class B
        extends 5A {
            B() {
                class A {
                    final /* synthetic */ BeanTestCase this$0;

                    A(BeanTestCase beanTestCase) {
                        this.this$0 = beanTestCase;
                    }

                    public void setA(String a) {
                    }
                }
                super(BeanTestCase.this);
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", String.class, AccessMode.WRITE_ONLY));
    }

    public void testGetterSetterInheritance() throws Exception {
        class B
        extends 6A {
            B() {
                class A {
                    final /* synthetic */ BeanTestCase this$0;

                    A(BeanTestCase beanTestCase) {
                        this.this$0 = beanTestCase;
                    }

                    public String getA() {
                        return null;
                    }

                    public void setA(String a) {
                    }
                }
                super(BeanTestCase.this);
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", String.class, AccessMode.READ_WRITE));
    }

    public void testGetterOverride() throws Exception {
        class B
        extends 7A {
            B() {
                class A {
                    final /* synthetic */ BeanTestCase this$0;

                    A(BeanTestCase beanTestCase) {
                        this.this$0 = beanTestCase;
                    }

                    public String getA() {
                        return null;
                    }
                }
                super(BeanTestCase.this);
            }

            public String getA() {
                return null;
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", String.class, AccessMode.READ_ONLY));
    }

    public void testSetterOverride() throws Exception {
        class B
        extends 8A {
            B() {
                class A {
                    final /* synthetic */ BeanTestCase this$0;

                    A(BeanTestCase beanTestCase) {
                        this.this$0 = beanTestCase;
                    }

                    public void setA(String a) {
                    }
                }
                super(BeanTestCase.this);
            }

            public void setA(String a) {
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", String.class, AccessMode.WRITE_ONLY));
    }

    public void testGetterSetterOverride() throws Exception {
        class B
        extends 9A {
            B() {
                class A {
                    final /* synthetic */ BeanTestCase this$0;

                    A(BeanTestCase beanTestCase) {
                        this.this$0 = beanTestCase;
                    }

                    public String getA() {
                        return null;
                    }

                    public void setA(String a) {
                    }
                }
                super(BeanTestCase.this);
            }

            public String getA() {
                return null;
            }

            public void setA(String a) {
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", String.class, AccessMode.READ_WRITE));
    }

    public void testSetterOverloading1() throws Exception {
        class A {
            A() {
            }

            public void setA(String a) {
            }

            public void setA(Integer a) {
            }
        }
        this.assertProperties(A.class, new PropertyMetaData("a", Integer.class, AccessMode.WRITE_ONLY));
    }

    public void testSetterOverloading2() throws Exception {
        class A {
            A() {
            }

            public void setA(Integer a) {
            }

            public void setA(String a) {
            }
        }
        this.assertProperties(A.class, new PropertyMetaData("a", String.class, AccessMode.WRITE_ONLY));
    }

    public void testReadWriteSubclass1() throws Exception {
        class B
        extends 12A {
            B() {
                class A {
                    final /* synthetic */ BeanTestCase this$0;

                    A(BeanTestCase beanTestCase) {
                        this.this$0 = beanTestCase;
                    }

                    public String getA() {
                        return null;
                    }
                }
                super(BeanTestCase.this);
            }

            public void setA(String a) {
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", String.class, AccessMode.READ_WRITE));
    }

    public void testReadWriteSubclass2() throws Exception {
        class B
        extends 13A {
            B() {
                class A {
                    final /* synthetic */ BeanTestCase this$0;

                    A(BeanTestCase beanTestCase) {
                        this.this$0 = beanTestCase;
                    }

                    public void setA(String a) {
                    }
                }
                super(BeanTestCase.this);
            }

            public String getA() {
                return null;
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", String.class, AccessMode.READ_WRITE));
    }

    public void testGetterAndSetterWithDifferentType() throws Exception {
        class A {
            A() {
            }

            public String getA() {
                return null;
            }

            public void setA(Integer a) {
            }
        }
        this.assertProperties(A.class, new PropertyMetaData("a", String.class, AccessMode.READ_ONLY));
    }
}

