/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.util.Collections;
import org.chromattic.metamodel.bean.AbstractBeanTestCase;
import org.chromattic.metamodel.bean.AccessMode;
import org.chromattic.metamodel.bean.BeanInfo;
import org.reflext.api.ClassTypeInfo;

public class ReadWritePropertyTestCase
extends AbstractBeanTestCase {
    public void testConsistentGetterAndSetter() {
        ClassTypeInfo typeInfo = (ClassTypeInfo)this.domain.resolve(ConsistentGetterAndSetter.class);
        BeanInfo beanInfo = this.beanInfo(typeInfo);
        ReadWritePropertyTestCase.assertEquals(Collections.singleton("a"), beanInfo.getProperties().keySet());
        this.assertProperty(beanInfo.getProperty("a"), "a", String.class, AccessMode.READ_WRITE);
    }

    public void testGetterAndSetterWithDifferentTypes() {
        ClassTypeInfo typeInfo = (ClassTypeInfo)this.domain.resolve(GetterAndSetterWithDifferentTypes.class);
        BeanInfo beanInfo = this.beanInfo(typeInfo);
        ReadWritePropertyTestCase.assertEquals(Collections.singleton("a"), beanInfo.getProperties().keySet());
        this.assertProperty(beanInfo.getProperty("a"), "a", String.class, AccessMode.READ_ONLY);
    }

    public class GetterAndSetterWithDifferentTypes {
        public String getA() {
            throw new UnsupportedOperationException();
        }

        public void setA(Exception a) {
            throw new UnsupportedOperationException();
        }
    }

    public class ConsistentGetterAndSetter {
        public String getA() {
            throw new UnsupportedOperationException();
        }

        public void setA(String a) {
            throw new UnsupportedOperationException();
        }
    }
}

