/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.beans.PropertyDescriptor;
import org.chromattic.metamodel.bean.AccessMode;
import org.chromattic.metamodel.bean.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyMetaData {
    final String name;
    final Class<?> type;
    final AccessMode accessMode;

    PropertyMetaData(PropertyDescriptor pd) {
        this.name = pd.getName();
        this.type = pd.getPropertyType();
        this.accessMode = pd.getReadMethod() == null ? AccessMode.WRITE_ONLY : (pd.getWriteMethod() == null ? AccessMode.READ_ONLY : AccessMode.READ_WRITE);
    }

    PropertyMetaData(String name, Class<?> type, AccessMode accessMode) {
        this.name = name;
        this.type = type;
        this.accessMode = accessMode;
    }

    PropertyMetaData(PropertyInfo pi) {
        this.name = pi.getName();
        this.type = (Class)pi.getValue().getDeclaredType().unwrap();
        this.accessMode = pi.getGetter() == null ? AccessMode.WRITE_ONLY : (pi.getSetter() == null ? AccessMode.READ_ONLY : AccessMode.READ_WRITE);
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyMetaData) {
            PropertyMetaData that = (PropertyMetaData)o;
            return this.name.equals(that.name) && this.type.equals(that.type) && this.accessMode.equals((Object)that.accessMode);
        }
        return false;
    }

    public String toString() {
        return "PropertyMetaData[name=" + this.name + ",type=" + this.type + ",accessMode=" + (Object)((Object)this.accessMode) + "]";
    }
}

