/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator.sourcetransformer;

import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.MethodCallExpr;
import org.chromattic.testgenerator.sourcetransformer.TransformationProcessor;
import org.chromattic.testgenerator.sourcetransformer.TransformationSource;

public class JavaToGroovySyntaxTransformer
implements TransformationProcessor {
    protected TransformationSource transformationSource;

    public JavaToGroovySyntaxTransformer() {
    }

    public JavaToGroovySyntaxTransformer(TransformationSource transformationSource) {
        this.transformationSource = transformationSource;
    }

    public void setTransformationSource(TransformationSource transformationSource) {
        this.transformationSource = transformationSource;
    }

    public String transform(String source) {
        if (this.transformationSource == null) {
            throw new IllegalStateException("transformationSource must be initialized before transformation.");
        }
        String dst = source;
        dst = this.annotationBracket(dst);
        dst = this.genericCall(dst);
        return dst;
    }

    protected String annotationBracket(String source) {
        String tmpSrc = source;
        for (AnnotationExpr expr : this.transformationSource.getAnnotationExprs()) {
            String tmpExpr = expr.toString();
            tmpExpr = tmpExpr.replaceAll("\\{", "[");
            tmpExpr = tmpExpr.replaceAll("\\}", "]");
            tmpSrc = tmpSrc.replace(expr.toString(), tmpExpr);
        }
        return tmpSrc;
    }

    protected String genericCall(String source) {
        String tmpSrc = source;
        for (MethodCallExpr methodCallExpr : this.transformationSource.getMethodCallExprs()) {
            String tmpExpr = methodCallExpr.toString();
            if (methodCallExpr.getTypeArgs() == null) continue;
            tmpExpr = tmpExpr.replaceAll("<.*>", "");
            tmpSrc = tmpSrc.replace(methodCallExpr.toString(), tmpExpr);
        }
        return tmpSrc;
    }
}

