/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator.builder;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.visitor.DumpVisitorFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.chromattic.testgenerator.GroovyTestGeneration;
import org.chromattic.testgenerator.visitor.transformer.UnitTestVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyFromJavaSourceTestBuilder {
    private CompilationUnit compilationUnit;
    private StringBuilder sb = new StringBuilder();
    private String name;
    private Set<String> deps;

    public GroovyFromJavaSourceTestBuilder(CompilationUnit compilationUnit, String name, Set<String> deps) {
        this.compilationUnit = compilationUnit;
        this.name = name;
        this.deps = deps;
    }

    public void build(DumpVisitorFactory factory, List<String> excludedMethods) {
        UnitTestVisitor unitTestVisitor = new UnitTestVisitor(this.name);
        Iterator<ImportDeclaration> itImports = this.compilationUnit.getImports().iterator();
        while (itImports.hasNext()) {
            if (!GroovyTestGeneration.class.getName().equals(itImports.next().getName().toString())) continue;
            itImports.remove();
        }
        for (String dep : this.deps) {
            int i = dep.lastIndexOf(".");
            String depPackage = dep.substring(0, i) + ".groovy";
            String depImport = depPackage + dep.substring(i);
            this.compilationUnit.getImports().add(new ImportDeclaration(new NameExpr(depImport), false, false));
        }
        unitTestVisitor.visit(this.compilationUnit, excludedMethods);
        this.sb.append(this.compilationUnit.toString(factory));
    }

    public String toString() {
        return this.sb.toString();
    }
}

