/*
 * Decompiled with CFR 0.152.
 */
package grizzled.net;

import grizzled.net.IPAddress;
import java.io.Serializable;
import java.net.InetAddress;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class IPAddress$ {
    public static final IPAddress$ MODULE$ = new IPAddress$();
    private static final IPAddress Localhost = new IPAddress((byte[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{127, 0, 0, 1}), (ClassTag)ClassTag$.MODULE$.Byte()));
    private static final BigInt MaxIPv4 = package$.MODULE$.BigInt().apply("4294967295");
    private static final Regex IPv6Pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))(%.*)?$"));
    private static final Regex IPv4Pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$"));

    public IPAddress Localhost() {
        return Localhost;
    }

    private BigInt MaxIPv4() {
        return MaxIPv4;
    }

    private Regex IPv6Pattern() {
        return IPv6Pattern;
    }

    private Regex IPv4Pattern() {
        return IPv4Pattern;
    }

    public Try<IPAddress> apply(byte[] addr) {
        return this.apply((List<Object>)Predef$.MODULE$.wrapByteArray(addr).toList());
    }

    public Try<IPAddress> apply(int[] addr) {
        return this.apply((byte[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(addr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToByte((byte)IPAddress$.$anonfun$apply$1(BoxesRunTime.unboxToInt((Object)x$1))), (ClassTag)ClassTag$.MODULE$.Byte()));
    }

    public Try<IPAddress> apply(Seq<Object> addr) {
        return this.apply((List<Object>)((IterableOnceOps)addr.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)IPAddress$.$anonfun$apply$2(BoxesRunTime.unboxToInt((Object)x$2))))).toList());
    }

    public Try<IPAddress> apply(List<Object> address) {
        Success success;
        byte zeroByte = (byte)0;
        int n = address.length();
        switch (n) {
            case 4: {
                success = new Success(address);
                break;
            }
            case 16: {
                success = new Success(address);
                break;
            }
            case 0: {
                success = new Failure((Throwable)new IllegalArgumentException("Empty IP address."));
                break;
            }
            default: {
                if (n > 16) {
                    success = new Failure((Throwable)new IllegalArgumentException(new StringBuilder(24).append("IP address ").append(address.mkString(".")).append(" is too long.").toString()));
                    break;
                }
                int upper = n < 4 ? 4 : 16;
                success = new Success(address.$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(n), upper).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToByte((byte)zeroByte))));
                break;
            }
        }
        Success fullAddressRes = success;
        return fullAddressRes.map((Function1 & Serializable)bytes -> new IPAddress((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte())));
    }

    public IPAddress apply(InetAddress inetAddress) {
        return new IPAddress(inetAddress.getAddress());
    }

    public Try<IPAddress> apply(String host) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> InetAddress.getByName(host).getAddress()).flatMap((Function1 & Serializable)x$4 -> MODULE$.apply((byte[])x$4));
    }

    public Try<IPAddress> apply(BigInt address) {
        Try<IPAddress> try_;
        if (address.$less$eq((Object)this.MaxIPv4())) {
            byte[] bytes = new byte[]{address.$greater$greater(24).$amp(BigInt$.MODULE$.int2bigInt(255)).toByte(), address.$greater$greater(16).$amp(BigInt$.MODULE$.int2bigInt(255)).toByte(), address.$greater$greater(8).$amp(BigInt$.MODULE$.int2bigInt(255)).toByte(), address.$amp(BigInt$.MODULE$.int2bigInt(255)).toByte()};
            try_ = this.apply(bytes);
        } else {
            try_ = this.apply(address.toByteArray());
        }
        return try_;
    }

    public Try<IPAddress> parseAddress(String addressString) {
        Option option;
        Try<IPAddress> try_;
        Option option2;
        String string = addressString;
        if (string != null && !(option2 = this.IPv4Pattern().unapplySeq((CharSequence)string)).isEmpty()) {
            try_ = this.apply(addressString);
        } else if (string != null && !(option = this.IPv6Pattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) >= 0) {
            String a = (String)((LinearSeqOps)option.get()).apply(0);
            try_ = this.apply(a);
        } else {
            try_ = new Try<IPAddress>((Throwable)new IllegalArgumentException(new StringBuilder(20).append("Invalid IP address: ").append(addressString).toString()));
        }
        return try_;
    }

    public Try<List<IPAddress>> allForName(String hostname) {
        Try try_;
        List res = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])InetAddress.getAllByName(hostname)), (Function1 & Serializable)x -> MODULE$.apply(x.getAddress()), ClassTag$.MODULE$.apply(Try.class))).toList();
        List list = res.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isFailure()));
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Try failure = (Try)colon2.head();
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (List)new .colon.colon((Object)((IPAddress)failure.get()), (List)Nil$.MODULE$));
        } else if (Nil$.MODULE$.equals(list)) {
            try_ = new Success((Object)res.map((Function1 & Serializable)x$6 -> (IPAddress)x$6.get()));
        } else {
            throw new MatchError((Object)list);
        }
        return try_;
    }

    public static final /* synthetic */ byte $anonfun$apply$1(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$apply$2(int x$2) {
        return (byte)x$2;
    }

    private IPAddress$() {
    }
}

