/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.installer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Get;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.installer.Installer;
import org.codehaus.cargo.container.installer.Proxy;
import org.codehaus.cargo.container.internal.util.AntTaskFactory;
import org.codehaus.cargo.container.internal.util.AntUtils;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public class ZipURLInstaller
extends MonitoredObject
implements Installer {
    private URL remoteLocation;
    private File installDir;
    private Proxy proxy;
    private AntUtils antUtils = new AntUtils();

    public ZipURLInstaller(URL remoteLocation) {
        this(remoteLocation, null);
    }

    public ZipURLInstaller(URL remoteLocation, File installDir) {
        this.remoteLocation = remoteLocation;
        this.installDir = installDir;
    }

    protected void setAntTaskFactory(AntTaskFactory antTaskFactory) {
        this.antUtils = new AntUtils(antTaskFactory);
    }

    public void install() {
        if (!this.isAlreadyInstalled()) {
            this.createDestinationDirectory();
            this.download();
            this.unpack();
            this.registerInstallation();
        }
    }

    public void registerInstallation() {
        try {
            File timestampFile = new File(this.getDestinationDir(), this.getInstallDirName() + "/.cargo");
            BufferedWriter bw = new BufferedWriter(new FileWriter(timestampFile));
            bw.write("Do not remove this file");
            bw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAlreadyInstalled() {
        boolean isInstalled = false;
        File timestampFile = new File(this.getDestinationDir(), this.getInstallDirName() + "/.cargo");
        if (timestampFile.exists()) {
            isInstalled = true;
        }
        this.getMonitor().debug("Container [" + this.getSourceFileName() + "] is " + (isInstalled ? "already installed" : "not yet installed as timestamp file [" + timestampFile.getPath() + "] was not found"), this.getClass().getName());
        return isInstalled;
    }

    public File getHome() {
        File targetDir = new File(this.getDestinationDir(), this.getInstallDirName());
        File[] files = targetDir.listFiles();
        int nbDirectories = 0;
        File foundDirectory = null;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            ++nbDirectories;
            foundDirectory = files[i];
        }
        File home = nbDirectories != 1 ? targetDir : foundDirectory;
        return home;
    }

    private void unpack() {
        Expand expandTask = (Expand)this.antUtils.createAntTask("unzip");
        expandTask.setSrc(new File(this.getDestinationDir(), this.getSourceFileName()));
        expandTask.setDest(new File(this.getDestinationDir(), this.getInstallDirName()));
        expandTask.execute();
    }

    protected void download() {
        try {
            if (this.proxy != null) {
                this.proxy.configure();
            }
            this.doDownload();
        }
        catch (Exception e) {
            if (this.proxy != null) {
                try {
                    this.proxy.clear();
                    this.doDownload();
                }
                catch (Exception ee) {
                    throw new ContainerException("Failed to download [" + this.remoteLocation + "]", ee);
                }
            }
            throw new ContainerException("Failed to download [" + this.remoteLocation + "]", e);
        }
    }

    private void doDownload() {
        Get getTask = (Get)this.antUtils.createAntTask("get");
        getTask.setUseTimestamp(true);
        getTask.setSrc(this.remoteLocation);
        getTask.setDest(new File(this.getDestinationDir(), this.getSourceFileName()));
        getTask.execute();
    }

    protected String getSourceFileName() {
        int slashPos = this.remoteLocation.getPath().lastIndexOf(47);
        String name = this.remoteLocation.getPath();
        if (slashPos > -1) {
            name = this.remoteLocation.getPath().substring(slashPos + 1);
        }
        return name;
    }

    protected String getInstallDirName() {
        String name = this.getSourceFileName();
        int dotPos = name.lastIndexOf(".zip");
        if (dotPos > -1) {
            name = name.substring(0, dotPos);
        }
        return name;
    }

    private void createDestinationDirectory() {
        File destinationDir = this.getDestinationDir();
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
    }

    protected File getDestinationDir() {
        File dir = this.installDir;
        if (dir == null) {
            dir = new File(System.getProperty("java.io.tmpdir"), "cargo/installs");
        }
        return dir;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

