/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.internal.util.AntUtils;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.AbstractContainer;
import org.codehaus.cargo.container.spi.configuration.ContainerConfiguration;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.util.FileUtils;

public abstract class AbstractLocalContainer
extends AbstractContainer
implements LocalContainer {
    private Map systemProperties;
    private String[] extraClasspath;
    private File output;
    private boolean append;
    private File home;
    private JdkUtils jdkUtils;
    private AntUtils antUtils;
    private HttpUtils httpUtils;
    private ResourceUtils resourceUtils;
    private FileUtils fileUtils;
    private long timeout = 60000L;
    private LocalConfiguration configuration;
    private State state = State.STOPPED;

    public AbstractLocalContainer(LocalConfiguration configuration) {
        this.jdkUtils = new JdkUtils();
        this.fileUtils = new FileUtils();
        this.antUtils = new AntUtils();
        this.resourceUtils = new ResourceUtils();
        this.httpUtils = new HttpUtils();
        this.configuration = configuration;
    }

    protected final HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    protected final JdkUtils getJdkUtils() {
        return this.jdkUtils;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    protected final FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public final void setHome(File home) {
        this.home = home;
    }

    public final void setHome(String home) {
        this.home = new File(home);
    }

    public final void setOutput(File output) {
        this.output = output;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public void setSystemProperties(Map properties) {
        HashMap props = new HashMap();
        props.putAll(properties);
        this.systemProperties = props;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setExtraClasspath(String[] classpath) {
        this.extraClasspath = classpath;
    }

    public String[] getExtraClasspath() {
        return this.extraClasspath;
    }

    public final File getOutput() {
        return this.output;
    }

    public final boolean isAppend() {
        return this.append;
    }

    public final File getHome() {
        return this.home;
    }

    protected abstract void doStart(Java var1) throws Exception;

    protected void verify() {
        this.verifyHome();
        ((ContainerConfiguration)((Object)this.getConfiguration())).verifyProperties();
    }

    public final void start() {
        this.verify();
        this.getMonitor().info(this.getName() + " starting...", this.getClass().getName());
        this.setState(State.STARTING);
        try {
            this.doStart(this.createJavaForStartUp());
            this.waitForCompletion(true);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to start the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput().getPath() + "] file " + "containing the container logs for more details."), e);
        }
        this.setState(State.STARTED);
        this.getMonitor().info(this.getName() + " started on port [" + this.getConfiguration().getPropertyValue("cargo.servlet.port") + "]", this.getClass().getName());
    }

    protected abstract void doStop(Java var1) throws Exception;

    public final void stop() {
        this.verify();
        this.getMonitor().info(this.getName() + " is stopping...", this.getClass().getName());
        this.setState(State.STOPPING);
        try {
            this.doStop(this.createJavaForShutDown());
            this.waitForCompletion(false);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to stop the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput().getPath() + "] file " + "containing the container logs for more details."), e);
        }
        this.setState(State.STOPPED);
        this.getMonitor().info(this.getName() + " is stopped", this.getClass().getName());
    }

    private Java createJavaForShutDown() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        java.setOutput(this.getOutput());
        java.setAppend(true);
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getMonitor(), this.getClass().getName()));
        this.addExtraClasspath(java);
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            java.createJvmarg().setLine(jvmargs);
        }
        return java;
    }

    private Java createJavaForStartUp() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        java.setOutput(this.getOutput());
        java.setAppend(this.isAppend());
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getMonitor(), this.getClass().getName()));
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            java.createJvmarg().setLine(jvmargs);
        }
        return java;
    }

    private void addSystemProperties(Java java) {
        if (this.getSystemProperties() != null) {
            Iterator keys = this.getSystemProperties().keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                java.addSysproperty(this.getAntUtils().createSysProperty(key, (String)this.getSystemProperties().get(key)));
            }
        }
    }

    protected final void addToolsJarToClasspath(Path classpath) throws FileNotFoundException {
        if (!this.getJdkUtils().isOSX()) {
            classpath.createPathElement().setLocation(this.getJdkUtils().getToolsJar());
        }
    }

    private void addExtraClasspath(Java javaCommand) {
        Path classpath = javaCommand.createClasspath();
        if (this.getExtraClasspath() != null) {
            Path path = new Path(this.getAntUtils().createProject());
            for (int i = 0; i < this.getExtraClasspath().length; ++i) {
                Path pathElement = new Path(this.getAntUtils().createProject(), this.getExtraClasspath()[i]);
                path.addExisting(pathElement);
                this.getMonitor().debug("Adding [" + pathElement + "] to execution classpath", this.getClass().getName());
            }
            classpath.addExisting(path);
        }
    }

    private void verifyHome() {
        if (this.getHome() == null) {
            throw new ContainerException("You must set the mandatory [home] property");
        }
        if (!this.getHome().isDirectory()) {
            throw new ContainerException("[" + this.getHome() + "] is not a valid directory");
        }
    }

    private void waitForCompletion(boolean waitForStarting) throws MalformedURLException, InterruptedException {
        DeployerWatchdog watchdog = new DeployerWatchdog(new URLDeployableMonitor(ContainerUtils.getCPCURL(this.getConfiguration()), this.getTimeout()));
        watchdog.watch(waitForStarting);
        Thread.sleep(2000L);
    }

    public void setConfiguration(LocalConfiguration configuration) {
        this.configuration = configuration;
    }

    public LocalConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public ContainerType getType() {
        return ContainerType.LOCAL;
    }

    public abstract /* synthetic */ ContainerCapability getCapability();

    public abstract /* synthetic */ String getName();

    public abstract /* synthetic */ String getId();
}

