/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractLocalConfiguration;

public abstract class AbstractStandaloneLocalConfiguration
extends AbstractLocalConfiguration
implements StandaloneLocalConfiguration {
    public AbstractStandaloneLocalConfiguration(File dir) {
        super(dir);
        this.setProperty("cargo.logging", "medium");
    }

    protected void createConfigurationDir() throws IOException {
        File timestampFile = new File(this.getHome().getPath(), ".cargo");
        if (this.getHome().exists()) {
            if (this.getHome().list().length == 0) {
                timestampFile.createNewFile();
            }
        } else {
            if (!this.getHome().mkdirs()) {
                throw new IOException("Could not create configuration directory [" + this.getHome() + "]");
            }
            timestampFile.createNewFile();
        }
        if (!timestampFile.exists()) {
            throw new ContainerException("Invalid configuration dir [" + this.getHome() + "]. The configuration dir must point to an empty directory. Note that " + "everything in the configuration dir will get deleted by Cargo.");
        }
        this.cleanConfigurationDirectory();
    }

    private void cleanConfigurationDirectory() {
        Delete delete = (Delete)this.getAntUtils().createAntTask("delete");
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.getHome());
        fileSet.createInclude().setName("**/*");
        fileSet.createExclude().setName(".cargo");
        fileSet.setDefaultexcludes(false);
        delete.addFileset(fileSet);
        delete.setIncludeEmptyDirs(true);
        delete.setFailOnError(true);
        delete.setQuiet(false);
        delete.execute();
    }

    protected final FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.servlet.port", this.getPropertyValue("cargo.servlet.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.hostname", this.getPropertyValue("cargo.hostname"));
        return filterChain;
    }

    public void verifyProperties() {
        super.verifyProperties();
        this.verifyLogging();
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        if (!(level.equalsIgnoreCase("low") || level.equalsIgnoreCase("medium") || level.equalsIgnoreCase("high"))) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", " + "\"high\"}");
        }
    }

    public ConfigurationType getType() {
        return ConfigurationType.STANDALONE;
    }

    public abstract /* synthetic */ ConfigurationCapability getCapability();
}

