/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.property;

import java.util.Properties;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.internal.util.PropertyUtils;

public class ResourceConverter {
    public Resource fromPropertyString(String resourceInformation) {
        return this.fromProperties(PropertyUtils.splitPropertiesOnPipe(PropertyUtils.escapeBackSlashesIfNotNull(resourceInformation)));
    }

    public Resource fromProperties(Properties properties) {
        String name = properties.getProperty("cargo.resource.name");
        String type = properties.getProperty("cargo.resource.type");
        Resource data = new Resource(name, type);
        if (properties.containsKey("cargo.resource.class")) {
            String className = properties.getProperty("cargo.resource.class");
            data.setClassName(className);
        }
        String parametersAsASemicolonDelimitedString = properties.getProperty("cargo.resource.parameters");
        data.setParameters(this.getParametersFromString(PropertyUtils.escapeBackSlashesIfNotNull(parametersAsASemicolonDelimitedString)));
        return data;
    }

    private Properties getParametersFromString(String property) {
        if (property != null && !property.trim().equals("")) {
            return PropertyUtils.splitPropertiesOnSemicolon(property);
        }
        return new Properties();
    }

    public String toPropertyString(Resource data) {
        Properties properties = this.toProperties(data);
        return PropertyUtils.joinOnPipe(properties);
    }

    public Properties toProperties(Resource data) {
        Properties properties = new Properties();
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.resource.name", data.getName());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.resource.type", data.getType());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.resource.class", data.getClassName());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.resource.parameters", this.getParametersAsASemicolonDelimitedString(data));
        return properties;
    }

    public String getParametersAsASemicolonDelimitedString(Resource data) {
        if (data.getParameterNames().size() != 0) {
            return PropertyUtils.joinOnSemicolon(data.getParameters());
        }
        return null;
    }
}

