/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractLocalConfiguration;

public abstract class AbstractStandaloneLocalConfiguration
extends AbstractLocalConfiguration
implements StandaloneLocalConfiguration {
    private List files;
    private FilterChain filterChain;

    public AbstractStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.logging", "medium");
        this.files = new ArrayList();
    }

    public void configure(LocalContainer container) {
        super.configure(container);
        this.configureFiles(this.getFilterChain());
    }

    protected void setupConfigurationDir() throws IOException {
        String timestampFile = this.getFileHandler().append(this.getHome(), ".cargo");
        if (!(this.getFileHandler().exists(timestampFile) || this.getFileHandler().exists(this.getHome()) && this.getFileHandler().isDirectoryEmpty(this.getHome()) || !this.getFileHandler().exists(this.getHome()))) {
            throw new ContainerException("Invalid configuration dir [" + this.getHome() + "]. " + "When using standalone configurations, the configuration dir must point to an " + "empty directory. Note that everything in that dir will get deleted by Cargo.");
        }
        this.getFileHandler().delete(this.getHome());
        this.getFileHandler().mkdirs(this.getHome());
        this.getFileHandler().createFile(timestampFile);
    }

    protected final FilterChain createFilterChain() {
        this.filterChain = new FilterChain();
        this.getAntUtils().addTokensToFilterChain(this.filterChain, this.getProperties());
        return this.filterChain;
    }

    public void verify() {
        super.verify();
        this.verifyLogging();
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        if (!(level.equalsIgnoreCase("low") || level.equalsIgnoreCase("medium") || level.equalsIgnoreCase("high"))) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", " + "\"high\"}");
        }
    }

    public ConfigurationType getType() {
        return ConfigurationType.STANDALONE;
    }

    public FilterChain getFilterChain() {
        if (this.filterChain == null) {
            this.filterChain = this.createFilterChain();
        }
        return this.filterChain;
    }

    public void setFileProperty(FileConfig fileConfig) {
        this.files.add(fileConfig);
    }

    public void setConfigFileProperty(FileConfig fileConfig) {
        fileConfig.setOverwrite(true);
        fileConfig.setConfigfile(true);
        this.setFileProperty(fileConfig);
    }

    public List getFileProperties() {
        return this.files;
    }

    protected void configureFiles(FilterChain filterChain) {
        List files = this.files;
        for (int i = 0; i < files.size(); ++i) {
            FileConfig fileConfig = (FileConfig)files.get(i);
            boolean isDirectory = false;
            if (fileConfig.getFile() == null) {
                throw new RuntimeException("File cannot be null");
            }
            File origFile = new File(fileConfig.getFile());
            if (origFile.isDirectory()) {
                isDirectory = true;
            }
            String destFile = this.getDestFileLocation(fileConfig.getFile(), fileConfig.getToDir(), fileConfig.getToFile());
            if (origFile.exists() && !fileConfig.getOverwrite()) continue;
            if (fileConfig.getConfigfile()) {
                this.getFileHandler().copyFile(fileConfig.getFile(), destFile, filterChain);
                continue;
            }
            if (isDirectory) {
                String destDir = this.getDestDirectoryLocation(fileConfig.getFile(), fileConfig.getToDir());
                this.getFileHandler().copyDirectory(fileConfig.getFile(), destDir);
                continue;
            }
            this.getFileHandler().copyFile(fileConfig.getFile(), destFile, fileConfig.getOverwrite());
        }
    }

    protected String getDestFileLocation(String file, String toDir, String toFile) {
        String filename;
        String fileName = file;
        String finalFile = null;
        if (fileName == null) {
            throw new RuntimeException("file cannot be null");
        }
        if (toFile == null && toDir != null) {
            filename = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            finalFile = this.getHome() + "/" + toDir + "/" + filename;
        } else if (toFile != null && toDir == null) {
            finalFile = this.getHome() + "/" + toFile;
        } else if (toFile == null && toDir == null) {
            filename = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            finalFile = this.getHome() + "/" + filename;
        } else if (toFile != null && toDir != null) {
            finalFile = this.getHome() + "/" + toDir + "/" + toFile;
        }
        while (finalFile.contains("//")) {
            finalFile = finalFile.replaceAll("//", "/");
        }
        return finalFile;
    }

    protected String getDestDirectoryLocation(String file, String toDir) {
        String fileName = file;
        String finalDir = null;
        if (fileName == null) {
            throw new RuntimeException("file cannot be null");
        }
        if (toDir != null) {
            finalDir = this.getHome() + "/" + toDir;
        } else if (toDir == null) {
            finalDir = this.getHome();
        }
        while (finalDir.contains("//")) {
            finalDir = finalDir.replaceAll("//", "/");
        }
        return finalDir;
    }
}

