/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.installer;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.util.log.LoggedObject;

public class Proxy
extends LoggedObject {
    private String host;
    private int port = 80;
    private String user;
    private String password;
    private String excludeHosts = "";

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setExcludeHosts(String proxyExcludeHosts) {
        this.excludeHosts = proxyExcludeHosts;
    }

    public String getExcludeHosts() {
        return this.excludeHosts;
    }

    public Map<String, String> configure() {
        HashMap<String, String> previousProperties = new HashMap<String, String>();
        if (this.getHost() != null && !this.getHost().trim().isEmpty()) {
            this.getLogger().debug("host : " + this.getHost(), ((Object)((Object)this)).getClass().getName());
            this.getLogger().debug("port : " + this.getPort(), ((Object)((Object)this)).getClass().getName());
            this.getLogger().debug("excludeHosts : " + this.getExcludeHosts(), ((Object)((Object)this)).getClass().getName());
            this.getLogger().debug("user : " + this.getUser(), ((Object)((Object)this)).getClass().getName());
            String host = this.getHost().trim();
            String port = Integer.toString(this.getPort());
            previousProperties.put("http.proxyHost", System.setProperty("http.proxyHost", host));
            previousProperties.put("http.proxyPort", System.setProperty("http.proxyPort", port));
            previousProperties.put("https.proxyHost", System.setProperty("https.proxyHost", host));
            previousProperties.put("https.proxyPort", System.setProperty("https.proxyPort", port));
            previousProperties.put("ftp.proxyHost", System.setProperty("ftp.proxyHost", host));
            previousProperties.put("ftp.proxyPort", System.setProperty("ftp.proxyPort", port));
            if (this.getExcludeHosts() != null && !this.getExcludeHosts().trim().isEmpty()) {
                String excludedHosts = this.getExcludeHosts().trim();
                previousProperties.put("http.nonProxyHosts", System.setProperty("http.nonProxyHosts", excludedHosts));
                previousProperties.put("https.nonProxyHosts", System.setProperty("https.nonProxyHosts", excludedHosts));
                previousProperties.put("ftp.nonProxyHosts", System.setProperty("ftp.nonProxyHosts", excludedHosts));
            } else {
                previousProperties.put("http.nonProxyHosts", System.clearProperty("http.nonProxyHosts"));
                previousProperties.put("https.nonProxyHosts", System.clearProperty("https.nonProxyHosts"));
                previousProperties.put("ftp.nonProxyHosts", System.clearProperty("ftp.nonProxyHosts"));
            }
            if (this.getUser() != null && !this.getUser().trim().isEmpty()) {
                String password;
                String user = this.getUser().trim();
                previousProperties.put("http.proxyUser", System.setProperty("http.proxyUser", user));
                previousProperties.put("https.proxyUser", System.setProperty("https.proxyUser", user));
                previousProperties.put("ftp.proxyUser", System.setProperty("ftp.proxyUser", user));
                if (this.getPassword() != null && !this.getPassword().trim().isEmpty()) {
                    password = this.getPassword().trim();
                    previousProperties.put("http.proxyPassword", System.setProperty("http.proxyPassword", password));
                    previousProperties.put("https.proxyPassword", System.setProperty("https.proxyPassword", password));
                    previousProperties.put("ftp.proxyPassword", System.setProperty("ftp.proxyPassword", password));
                } else {
                    password = "";
                    previousProperties.put("http.proxyPassword", System.clearProperty("http.proxyPassword"));
                    previousProperties.put("https.proxyPassword", System.clearProperty("https.proxyPassword"));
                    previousProperties.put("ftp.proxyPassword", System.clearProperty("ftp.proxyPassword"));
                }
                Authenticator.setDefault(new ProxyAuthenticator(user, password));
            } else {
                previousProperties.put("http.proxyUser", System.clearProperty("http.proxyUser"));
                previousProperties.put("https.proxyUser", System.clearProperty("https.proxyUser"));
                previousProperties.put("ftp.proxyUser", System.clearProperty("ftp.proxyUser"));
                previousProperties.put("http.proxyPassword", System.clearProperty("http.proxyPassword"));
                previousProperties.put("https.proxyPassword", System.clearProperty("https.proxyPassword"));
                previousProperties.put("ftp.proxyPassword", System.clearProperty("ftp.proxyPassword"));
            }
        }
        return previousProperties;
    }

    public void clear(Map<String, String> previousProperties) {
        if (previousProperties != null) {
            for (Map.Entry<String, String> previousProperty : previousProperties.entrySet()) {
                if (previousProperty.getValue() != null) {
                    System.setProperty(previousProperty.getKey(), previousProperty.getValue());
                    continue;
                }
                System.clearProperty(previousProperty.getKey());
            }
            Authenticator.setDefault(null);
        }
    }

    private static final class ProxyAuthenticator
    extends Authenticator {
        private PasswordAuthentication authentication;

        private ProxyAuthenticator(String user, String password) {
            this.authentication = new PasswordAuthentication(user, password.toCharArray());
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

