/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployable;

public final class DeployableVersion {
    public static final DeployableVersion J2EE = new DeployableVersion("j2ee");
    public static final DeployableVersion JAVA_EE = new DeployableVersion("javaee");
    public static final DeployableVersion JAKARTA_EE = new DeployableVersion("jakartaee");
    private String version;

    private DeployableVersion(String version) {
        this.version = version;
    }

    public static DeployableVersion toVersion(String versionAsString) {
        DeployableVersion version;
        if (versionAsString.equalsIgnoreCase(DeployableVersion.J2EE.version)) {
            version = J2EE;
        } else if (versionAsString.equalsIgnoreCase(DeployableVersion.JAVA_EE.version)) {
            version = JAVA_EE;
        } else if (versionAsString.equalsIgnoreCase(DeployableVersion.JAKARTA_EE.version)) {
            version = JAKARTA_EE;
        } else {
            throw new IllegalArgumentException("Invalid deployable version: " + versionAsString);
        }
        return version;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof DeployableVersion) {
            DeployableVersion version = (DeployableVersion)object;
            if (version.version.equalsIgnoreCase(this.version)) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.version;
    }
}

