/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployer;

import java.net.URL;
import org.codehaus.cargo.container.deployer.AbstractDeployableMonitor;
import org.codehaus.cargo.container.internal.util.HttpUtils;

public class URLDeployableMonitor
extends AbstractDeployableMonitor {
    private URL pingURL;
    private HttpUtils httpUtils = new HttpUtils();
    private String contains;

    public URLDeployableMonitor(URL pingURL) {
        this.pingURL = pingURL;
    }

    public URLDeployableMonitor(URL pingURL, long timeout) {
        super(timeout);
        this.pingURL = pingURL;
    }

    public URLDeployableMonitor(URL pingURL, long timeout, String contains) {
        super(timeout);
        this.pingURL = pingURL;
        this.contains = contains;
    }

    @Override
    public String getDeployableName() {
        return this.pingURL.toString();
    }

    @Override
    public void monitor() {
        this.getLogger().debug("Checking URL [" + this.pingURL + "] for status using a timeout of [" + this.getTimeout() + "] ms...", this.getClass().getName());
        HttpUtils.HttpResult result = new HttpUtils.HttpResult();
        boolean isDeployed = this.httpUtils.ping(this.pingURL, result, this.getTimeout());
        if (isDeployed && this.contains != null) {
            isDeployed = result.responseBody != null ? result.responseBody.contains(this.contains) : false;
        }
        String msg = "URL [" + this.pingURL + "] is ";
        msg = isDeployed ? msg + "responding..." : msg + "not responding: " + result.responseCode + " " + result.responseMessage;
        this.getLogger().debug(msg, this.getClass().getName());
        this.notifyListeners(isDeployed);
    }
}

