/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.http;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.codehaus.cargo.container.internal.http.HttpRequest;

public class HttpFileRequest
extends HttpRequest {
    private File file;

    public HttpFileRequest(URL url, File file) {
        super(url);
        this.file = file;
    }

    public HttpFileRequest(URL url, File file, long timeout) {
        super(url, timeout);
        this.file = file;
    }

    @Override
    protected void writeOutputStream(HttpURLConnection connection) throws IOException {
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setDoOutput(true);
        connection.setChunkedStreamingMode(262144);
        try (FileInputStream fileInputStream = new FileInputStream(this.file);
             OutputStream outputStream = connection.getOutputStream();
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            int n;
            byte[] bytes = new byte[262144];
            while ((n = ((InputStream)fileInputStream).read(bytes)) != -1) {
                outputStream.write(bytes, 0, n);
            }
            outputStream.flush();
        }
    }
}

