/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.http;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.codehaus.cargo.container.internal.http.FormContentType;
import org.codehaus.cargo.container.internal.http.HttpRequest;
import org.codehaus.cargo.container.internal.http.MultipartFormContentType;
import org.codehaus.cargo.container.internal.http.writer.MultipartFormWriter;
import org.codehaus.cargo.container.internal.http.writer.UrlEncodedFormWriter;

public class HttpFormRequest
extends HttpRequest {
    private FormContentType formData;

    public HttpFormRequest(URL url, FormContentType formData) {
        super(url);
        this.formData = formData;
    }

    public HttpFormRequest(URL url, FormContentType formData, long timeout) {
        super(url, timeout);
        this.formData = formData;
    }

    @Override
    protected void writeOutputStream(HttpURLConnection connection) throws IOException {
        connection.setRequestProperty("Content-Type", this.formData.getContentType());
        connection.setDoOutput(true);
        if (this.formData instanceof MultipartFormContentType) {
            MultipartFormContentType multipartFormData = (MultipartFormContentType)this.formData;
            connection.setChunkedStreamingMode(262144);
            try (MultipartFormWriter writer = new MultipartFormWriter(multipartFormData, connection.getOutputStream());){
                for (Map.Entry<String, String> entry : multipartFormData.getFormContents().entrySet()) {
                    writer.writeField(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Object> entry : multipartFormData.getFormFiles().entrySet()) {
                    writer.writeFile(entry.getKey(), (File)entry.getValue());
                }
            }
        } else {
            UrlEncodedFormWriter urlEncodedFormWriter = new UrlEncodedFormWriter();
            for (Map.Entry<String, String> entry : this.formData.getFormContents().entrySet()) {
                urlEncodedFormWriter.addField(entry.getKey(), entry.getValue());
            }
            connection.setRequestProperty("Content-Length", String.valueOf(urlEncodedFormWriter.getLength()));
            urlEncodedFormWriter.write(connection.getOutputStream());
        }
    }
}

