/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployer;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public abstract class AbstractJsr88Deployer
extends AbstractRemoteDeployer {
    private final RuntimeConfiguration configuration;
    private final FileHandler fileHandler;
    private long timeout;

    public AbstractJsr88Deployer(RemoteContainer container) {
        super(container);
        this.configuration = container.getConfiguration();
        this.fileHandler = new DefaultFileHandler();
        this.fileHandler.setLogger(this.getLogger());
        String timeout = this.configuration.getPropertyValue("cargo.remote.timeout");
        this.timeout = Long.parseLong(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(Deployable deployable) {
        File deployableFile;
        File tempDirectory;
        if (deployable.getType() == DeployableType.WAR) {
            WAR war = (WAR)deployable;
            String localFileName = war.getContext().isEmpty() ? "rootContext.war" : war.getContext() + ".war";
            tempDirectory = new File(this.fileHandler.createUniqueTmpDirectory());
            deployableFile = new File(tempDirectory, localFileName);
            this.fileHandler.copyFile(deployable.getFile(), deployableFile.getAbsolutePath());
        } else if (deployable.getType() == DeployableType.EAR) {
            EAR ear = (EAR)deployable;
            String localFileName = ear.getName() + ".ear";
            tempDirectory = new File(this.fileHandler.createUniqueTmpDirectory());
            deployableFile = new File(tempDirectory, localFileName);
            this.fileHandler.copyFile(deployable.getFile(), deployableFile.getAbsolutePath());
        } else {
            deployableFile = new File(deployable.getFile());
            tempDirectory = null;
        }
        try {
            DeploymentManager deploymentManager = this.getDeploymentManager();
            ProgressObject progressObject = deploymentManager.distribute(this.filterTargets(deploymentManager.getTargets()), deployableFile, null);
            this.waitForProgressObject("Distributing", progressObject);
            progressObject = deploymentManager.start(progressObject.getResultTargetModuleIDs());
            this.waitForProgressObject("Starting", progressObject);
        }
        finally {
            if (tempDirectory != null) {
                if (!deployableFile.delete()) {
                    this.getLogger().warn("Cannot delete the temporary file: " + deployableFile, this.getClass().getName());
                }
                if (!tempDirectory.delete()) {
                    this.getLogger().warn("Cannot delete the temporary directory: " + tempDirectory, this.getClass().getName());
                }
            }
        }
    }

    @Override
    public void undeploy(Deployable deployable) {
        TargetModuleID[] targetModules;
        DeploymentManager deploymentManager = this.getDeploymentManager();
        try {
            targetModules = this.findTargetModule(deploymentManager, deployable);
        }
        catch (TargetException e) {
            throw new CargoException("Cannot communicate with the server", (Throwable)e);
        }
        ProgressObject progressObject = deploymentManager.stop(targetModules);
        this.waitForProgressObject("Stopping", progressObject);
        progressObject = deploymentManager.undeploy(targetModules);
        this.waitForProgressObject("Undeploying", progressObject);
    }

    @Override
    public void redeploy(Deployable deployable) {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        TargetModuleID[] targetModules = null;
        try {
            targetModules = this.findTargetModule(deploymentManager, deployable);
        }
        catch (TargetException e) {
            throw new CargoException("Cannot communicate with the server", (Throwable)e);
        }
        catch (CargoException e) {
            // empty catch block
        }
        if (targetModules != null) {
            ProgressObject progressObject = deploymentManager.stop(targetModules);
            this.waitForProgressObject("Stopping", progressObject);
            progressObject = deploymentManager.undeploy(targetModules);
            this.waitForProgressObject("Undeploying", progressObject);
        }
        this.deploy(deployable);
    }

    @Override
    public void start(Deployable deployable) {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        TargetModuleID[] targetModules = null;
        try {
            targetModules = this.findTargetModule(deploymentManager, deployable);
        }
        catch (TargetException e) {
            throw new CargoException("Cannot communicate with the server", (Throwable)e);
        }
        ProgressObject progressObject = deploymentManager.start(targetModules);
        this.waitForProgressObject("Starting", progressObject);
    }

    @Override
    public void stop(Deployable deployable) {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        TargetModuleID[] targetModules = null;
        try {
            targetModules = this.findTargetModule(deploymentManager, deployable);
        }
        catch (TargetException e) {
            throw new CargoException("Cannot communicate with the server", (Throwable)e);
        }
        ProgressObject progressObject = deploymentManager.stop(targetModules);
        this.waitForProgressObject("Stopping", progressObject);
    }

    private void waitForProgressObject(String reason, ProgressObject progressObject) throws CargoException {
        long timeout = System.currentTimeMillis() + this.timeout;
        while (System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new CargoException("Thread.sleep failed", (Throwable)e);
            }
            DeploymentStatus status = progressObject.getDeploymentStatus();
            if (status.isCompleted()) {
                return;
            }
            if (!status.isFailed()) continue;
            throw new CargoException(reason + " failed: " + status.getMessage());
        }
        throw new CargoException(reason + " timed out after " + this.timeout + " milliseconds");
    }

    private DeploymentManager getDeploymentManager() throws CargoException {
        DeploymentFactoryManager dfm = DeploymentFactoryManager.getInstance();
        String deploymentFactoryClassName = this.getDeploymentFactoryClassName();
        try {
            Class<?> deploymentFactoryClass = null;
            ClassLoader tcccl = Thread.currentThread().getContextClassLoader();
            if (tcccl != null) {
                try {
                    deploymentFactoryClass = tcccl.loadClass(deploymentFactoryClassName);
                }
                catch (ClassNotFoundException e) {
                    deploymentFactoryClass = null;
                }
            }
            if (deploymentFactoryClass == null) {
                deploymentFactoryClass = this.getClass().getClassLoader().loadClass(deploymentFactoryClassName);
            }
            Constructor<?> deploymentFactoryConstructor = deploymentFactoryClass.getConstructor(new Class[0]);
            DeploymentFactory deploymentFactoryInstance = (DeploymentFactory)deploymentFactoryConstructor.newInstance(new Object[0]);
            dfm.registerDeploymentFactory(deploymentFactoryInstance);
        }
        catch (ClassNotFoundException e) {
            throw new CargoException("Cannot locate the JSR-88 deployer class " + deploymentFactoryClassName + "\nMake sure the target server's librarires are in Codehaus Cargo's classpath.\nRead more on: https://codehaus-cargo.github.io/cargo/JSR88.html", (Throwable)e);
        }
        catch (Throwable t) {
            throw new CargoException("Cannot create a JSR-88 deployer: " + t.getMessage(), t);
        }
        try {
            return this.getDeploymentManager(dfm);
        }
        catch (DeploymentManagerCreationException e) {
            throw new CargoException("Cannot create the DeploymentManager", (Throwable)e);
        }
    }

    protected abstract String getDeploymentFactoryClassName();

    protected abstract DeploymentManager getDeploymentManager(DeploymentFactoryManager var1) throws DeploymentManagerCreationException;

    private TargetModuleID[] findTargetModule(DeploymentManager deploymentManager, Deployable deployable) throws CargoException, TargetException {
        ModuleType moduleType;
        String moduleName;
        if (deployable.getType() == DeployableType.WAR) {
            WAR war = (WAR)deployable;
            moduleName = war.getContext().isEmpty() ? "rootContext" : war.getContext();
        } else if (deployable.getType() == DeployableType.EAR) {
            EAR ear = (EAR)deployable;
            moduleName = ear.getName();
        } else {
            File moduleFile = new File(deployable.getFile());
            moduleName = moduleFile.getName();
            int extensionSeparator = moduleName.lastIndexOf(46);
            if (extensionSeparator != -1) {
                moduleName = moduleName.substring(0, extensionSeparator);
            }
        }
        if (DeployableType.EAR.equals(deployable.getType())) {
            moduleType = ModuleType.EAR;
        } else if (DeployableType.EJB.equals(deployable.getType())) {
            moduleType = ModuleType.EJB;
        } else if (DeployableType.RAR.equals(deployable.getType())) {
            moduleType = ModuleType.RAR;
        } else if (DeployableType.WAR.equals(deployable.getType())) {
            moduleType = ModuleType.WAR;
        } else {
            throw new IllegalArgumentException("Codehaus Cargo deployable type " + deployable.getType() + " has no JSR-88 match and cannot be remotely deployed.");
        }
        TargetModuleID[] modules = deploymentManager.getAvailableModules(moduleType, deploymentManager.getTargets());
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot find the module \"");
        sb.append(moduleName);
        sb.append("\". Available modules:");
        ArrayList<TargetModuleID> targetModules = new ArrayList<TargetModuleID>();
        for (TargetModuleID module : modules) {
            String moduleId = module.getModuleID();
            if (moduleName.equals(moduleId)) {
                targetModules.add(module);
                continue;
            }
            sb.append("\n\t- ");
            sb.append(moduleId);
        }
        if (targetModules.isEmpty()) {
            throw new CargoException(sb.toString());
        }
        return this.filterTargetModuleIDs(targetModules);
    }

    protected RuntimeConfiguration getRuntimeConfiguration() {
        return this.configuration;
    }

    protected Target[] filterTargets(Target[] targets) {
        return targets;
    }

    protected TargetModuleID[] filterTargetModuleIDs(List<TargetModuleID> targetModuleIDs) {
        return targetModuleIDs.toArray(new TargetModuleID[targetModuleIDs.size()]);
    }
}

