/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.packager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.packager.Packager;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractDirectoryPackager
extends LoggedObject
implements Packager {
    private static final List<String> EXCLUDED_FROM_CONFIGURATION = Arrays.asList("**/cargocpc.war");
    private String targetDirectory;
    private FileHandler fileHandler = new DefaultFileHandler();

    public AbstractDirectoryPackager(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.fileHandler.setLogger(logger);
    }

    @Override
    public void packageContainer(InstalledLocalContainer container) {
        this.getFileHandler().copyDirectory(container.getHome(), this.getTargetDirectory(), this.getDistributionExclusions());
        ArrayList<String> configurationExclusions = new ArrayList<String>();
        configurationExclusions.addAll(this.getDefaultConfigurationExclusions());
        configurationExclusions.addAll(this.getConfigurationExclusions());
        this.getFileHandler().copyDirectory(container.getConfiguration().getHome(), this.getTargetDirectory(), configurationExclusions);
    }

    private List<String> getDefaultConfigurationExclusions() {
        return EXCLUDED_FROM_CONFIGURATION;
    }

    protected abstract List<String> getDistributionExclusions();

    protected abstract List<String> getConfigurationExclusions();
}

