/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.configuration.script;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.configuration.script.AbstractScriptCommand;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;

public abstract class AbstractResourceScriptCommand
extends AbstractScriptCommand {
    private String resourcePath;
    private ResourceUtils resourceUtils;

    public AbstractResourceScriptCommand(Configuration configuration, String resourcePath) {
        super(configuration);
        this.resourcePath = resourcePath;
        this.resourceUtils = new ResourceUtils();
    }

    @Override
    public String readScript() {
        HashMap<String, String> replacements = new HashMap<String, String>(this.getConfiguration().getProperties());
        this.addConfigurationScriptProperties(replacements);
        String resourceName = this.resourcePath + this.getScriptRelativePath();
        try {
            return this.resourceUtils.readResource(resourceName, replacements, StandardCharsets.UTF_8) + FileHandler.NEW_LINE;
        }
        catch (IOException e) {
            throw new CargoException("Error while reading resource [" + resourceName + "] ", (Throwable)e);
        }
    }

    protected abstract String getScriptRelativePath();

    protected void addConfigurationScriptProperties(Map<String, String> propertiesMap) {
    }

    protected Resource findResource(String type) {
        Resource foundResource = null;
        for (Resource resource : ((LocalConfiguration)this.getConfiguration()).getResources()) {
            if (!type.equals(resource.getType())) continue;
            foundResource = resource;
        }
        return foundResource;
    }
}

