/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.jvm;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.codehaus.cargo.container.spi.jvm.DefaultJvmLauncherLoggerRedirector;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.container.spi.jvm.JvmLauncherException;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.log.Logger;

public class DefaultJvmLauncher
implements JvmLauncher {
    public static boolean shutdownInProgress = false;
    private static final String PROCESS_ATTRIBUTE_CHANGE_MESSAGE = "Failed changing the visibility of internal JDK process classes, required for force killing of the Java process Codehaus Cargo has created. You could add --add-opens to your JVM arguments to allow this. ";
    private File workingDirectory;
    private String executable;
    private final List<String> jvmArguments = new ArrayList<String>();
    private String classpath;
    private String jarPath;
    private String mainClass;
    private final List<String> systemProperties = new ArrayList<String>();
    private final Map<String, String> environmentVariables = new HashMap<String, String>();
    private final List<String> applicationArguments = new ArrayList<String>();
    private long timeout = 60000L;
    private Process process;
    private File outputFile;
    private boolean appendOutput = false;
    private Logger outputLogger;
    private String category;

    private List<String> buildCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.executable == null) {
            throw new CargoException("Java executable not set");
        }
        commandLine.add(this.executable);
        commandLine.addAll(this.jvmArguments);
        commandLine.addAll(this.systemProperties);
        if (this.jarPath != null) {
            commandLine.add("-jar");
            commandLine.add(this.jarPath);
        } else {
            if (this.mainClass == null) {
                throw new CargoException("Neither JAR path nor main class is set");
            }
            if (this.classpath != null) {
                commandLine.add("-classpath");
                commandLine.add(this.classpath);
            }
            commandLine.add(this.mainClass);
        }
        commandLine.addAll(this.applicationArguments);
        return commandLine;
    }

    private void addClasspath(String path) {
        this.classpath = this.classpath == null ? path : this.classpath + File.pathSeparator + path;
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void setJvm(String command) {
        if (command == null || command.isEmpty()) {
            return;
        }
        if (!new File(command).isFile()) {
            throw new JvmLauncherException("JVM executable file [" + command + "] doesn't exist");
        }
        this.executable = command.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    @Override
    public void addJvmArgument(File file) {
        if (file != null) {
            this.jvmArguments.add(file.getAbsolutePath());
        }
    }

    @Override
    public void addJvmArguments(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.jvmArguments.add(value);
            }
        }
    }

    @Override
    public void addJvmArgumentLine(String line) {
        String[] args;
        if (line != null && (args = DefaultJvmLauncher.translateCommandline(line)) != null) {
            for (String arg : args) {
                this.jvmArguments.add(arg);
            }
        }
    }

    @Override
    public void addClasspathEntries(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                this.addClasspath(path);
            }
        }
    }

    public void addClasspathEntries(List<String> paths) {
        if (paths != null) {
            for (String path : paths) {
                this.addClasspath(path);
            }
        }
    }

    @Override
    public void addClasspathEntries(File ... paths) {
        if (paths != null) {
            for (File path : paths) {
                this.addClasspath(path.getAbsolutePath());
            }
        }
    }

    @Override
    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public void setSystemProperty(String name, String value) {
        if (name != null && !name.isEmpty()) {
            this.systemProperties.add("-D" + name + "=" + value);
        }
    }

    @Override
    public void setEnvironmentVariable(String name, String value) {
        if (name != null && !name.isEmpty()) {
            this.environmentVariables.put(name, value);
        }
    }

    @Override
    public String getEnvironmentVariable(String name) {
        String value = this.environmentVariables.get(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }

    @Override
    public void setJarFile(File jarFile) {
        if (jarFile != null) {
            this.jarPath = jarFile.getAbsolutePath();
        }
    }

    @Override
    public void setMainClass(String mainClass) {
        if (mainClass != null) {
            this.mainClass = mainClass;
        }
    }

    @Override
    public void addAppArgument(File file) {
        if (file != null) {
            this.applicationArguments.add(file.getAbsolutePath());
        }
    }

    @Override
    public void addAppArguments(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.applicationArguments.add(value);
            }
        }
    }

    @Override
    public void addAppArgumentLine(String line) {
        String[] args;
        if (line != null && (args = DefaultJvmLauncher.translateCommandline(line)) != null) {
            for (String arg : args) {
                this.applicationArguments.add(arg);
            }
        }
    }

    @Override
    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void setAppendOutput(boolean appendOutput) {
        this.appendOutput = appendOutput;
    }

    @Override
    public void setOutputLogger(Logger outputLogger, String category) {
        this.outputLogger = outputLogger;
        if (category == null) {
            throw new IllegalArgumentException("Logger category should not be null");
        }
        this.category = category;
    }

    @Override
    public String getCommandLine() {
        StringBuilder result = new StringBuilder();
        List<String> commandLine = this.buildCommandLine();
        if (commandLine != null) {
            for (int i = 0; i < commandLine.size(); ++i) {
                if (i != 0) {
                    result.append(' ');
                }
                result.append(commandLine.get(i));
            }
        }
        return result.toString();
    }

    @Override
    public void kill() {
        if (this.process != null) {
            block3: {
                this.process.destroy();
                try {
                    this.nativeKill();
                }
                catch (NoClassDefFoundError e) {
                    if (this.outputLogger == null) break block3;
                    this.outputLogger.debug(PROCESS_ATTRIBUTE_CHANGE_MESSAGE + e.getMessage(), this.getClass().getName());
                }
            }
            this.process = null;
            System.gc();
        }
    }

    @Override
    public void setTimeout(long millis) {
        this.timeout = millis;
    }

    @Override
    public void setSpawn(boolean spawn) {
    }

    @Override
    public void start() throws JvmLauncherException {
        try {
            ProcessBuilder pb = new ProcessBuilder(this.buildCommandLine()).directory(this.workingDirectory).redirectErrorStream(true);
            if (this.outputFile != null) {
                pb.redirectOutput(this.appendOutput ? ProcessBuilder.Redirect.appendTo(this.outputFile) : ProcessBuilder.Redirect.to(this.outputFile));
            }
            pb.environment().putAll(this.environmentVariables);
            this.process = pb.start();
            this.process.getOutputStream().close();
            if (this.outputFile == null) {
                if (this.outputLogger != null) {
                    Thread outputStreamRedirector = new Thread(new DefaultJvmLauncherLoggerRedirector(this.process.getInputStream(), this.outputLogger, this.category));
                    outputStreamRedirector.start();
                } else {
                    this.process.getErrorStream().close();
                    this.process.getInputStream().close();
                }
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    shutdownInProgress = true;
                    DefaultJvmLauncher.this.kill();
                }
            });
        }
        catch (IOException e) {
            try {
                throw new JvmLauncherException("Failed to launch process " + e);
            }
            catch (Throwable throwable) {
                Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    @Override
    public int execute() throws JvmLauncherException {
        this.start();
        try {
            if (this.process.waitFor(this.timeout, TimeUnit.MILLISECONDS)) {
                return this.process.exitValue();
            }
            try {
                this.kill();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new JvmLauncherException("Java command [" + this.getCommandLine() + "] did not complete after " + this.timeout + " milliseconds");
        }
        catch (InterruptedException e) {
            throw new JvmLauncherException("Failed waiting for process to end", e);
        }
    }

    private void nativeKill() {
        if (this.process == null) {
            return;
        }
        for (Field f : this.process.getClass().getDeclaredFields()) {
            if ("pid".equals(f.getName())) {
                if (!this.makeFieldAccessible(f)) break;
                try {
                    int pid = f.getInt(this.process);
                    Runtime.getRuntime().exec(new String[]{"kill", "-9", Integer.toString(pid)});
                }
                catch (Throwable pid) {}
                break;
            }
            if (!"handle".equals(f.getName())) continue;
            if (!this.makeFieldAccessible(f)) break;
            try {
                long handleId = f.getLong(this.process);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handleId));
                int pid = kernel.GetProcessId(handle);
                Runtime.getRuntime().exec(new String[]{"taskkill", "/PID", Integer.toString(pid), "/F"});
            }
            catch (Throwable throwable) {}
            break;
        }
    }

    private boolean makeFieldAccessible(Field f) {
        Method getModule;
        try {
            getModule = Class.class.getMethod("getModule", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getModule = null;
        }
        if (getModule != null) {
            try {
                Object thisModule = getModule.invoke(this.getClass(), new Object[0]);
                Method isNamed = thisModule.getClass().getMethod("isNamed", new Class[0]);
                if (!((Boolean)isNamed.invoke(thisModule, new Object[0])).booleanValue()) {
                    Class<?> fieldClass = f.getDeclaringClass().getClass();
                    Object fieldModule = getModule.invoke(fieldClass, new Object[0]);
                    Method addOpens = fieldModule.getClass().getMethod("addOpens", String.class, thisModule.getClass());
                    Method getPackageName = fieldClass.getMethod("getPackageName", new Class[0]);
                    addOpens.invoke(fieldModule, getPackageName.invoke(fieldClass, new Object[0]), thisModule);
                }
            }
            catch (Throwable t2) {
                Object t2;
                InvocationTargetException e;
                if (t2 instanceof InvocationTargetException && (e = (InvocationTargetException)t2).getCause() != null && e.getCause().getClass().getName().endsWith("IllegalCallerException")) {
                    if (this.outputLogger != null) {
                        this.outputLogger.debug(PROCESS_ATTRIBUTE_CHANGE_MESSAGE + e.getCause().getMessage(), this.getClass().getName());
                    }
                    t2 = null;
                }
                if (t2 != null) {
                    throw new CargoException("Cannot set field accessibility for [" + f + "]", (Throwable)t2);
                }
                return false;
            }
        }
        try {
            f.setAccessible(true);
            return true;
        }
        catch (Throwable t) {
            if (t.getClass().getName().endsWith("InaccessibleObjectException")) {
                if (this.outputLogger != null) {
                    this.outputLogger.debug(PROCESS_ATTRIBUTE_CHANGE_MESSAGE + t.getMessage(), this.getClass().getName());
                }
                t = null;
            }
            if (t != null) {
                throw new CargoException("Cannot set field accessibility for [" + f + "]", t);
            }
            return false;
        }
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.isEmpty()) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() > 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new CargoException("unbalanced quotes in " + toProcess);
        }
        return result.toArray(new String[result.size()]);
    }
}

