/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.configuration.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.script.AbstractScriptCommand;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public class FileScriptCommand
extends AbstractScriptCommand {
    private String filePath;
    private FileHandler fileHandler;

    public FileScriptCommand(Configuration configuration, String filePath) {
        super(configuration);
        this.filePath = filePath;
        this.fileHandler = new DefaultFileHandler();
        this.fileHandler.setLogger(configuration.getLogger());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String readScript() {
        try (InputStream resource = this.fileHandler.getInputStream(this.filePath);){
            String string;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
                String line;
                StringBuilder out = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (line.isEmpty()) {
                        out.append(FileHandler.NEW_LINE);
                        continue;
                    }
                    if (out.length() > 0) {
                        out.append(FileHandler.NEW_LINE);
                    }
                    out.append(line);
                }
                String output = out.toString();
                Map<String, String> replacements = this.getConfiguration().getProperties();
                if (replacements != null) {
                    for (Map.Entry entry : replacements.entrySet()) {
                        String replacementKey = "@" + (String)entry.getKey() + "@";
                        output = output.replace(replacementKey, (CharSequence)entry.getValue());
                    }
                }
                string = output;
            }
            return string;
        }
        catch (IOException e) {
            throw new CargoException("Error while reading file [" + this.filePath + "] ", (Throwable)e);
        }
    }
}

