/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.codehaus.cargo.container.internal.http.HttpRequest;
import org.codehaus.cargo.util.log.LoggedObject;

public class HttpUtils
extends LoggedObject {
    public boolean ping(URL pingURL) {
        return this.isAvailable(this.testConnectivity(pingURL, null, 0L));
    }

    public boolean ping(URL pingURL, HttpResult result) {
        return this.ping(pingURL, null, result);
    }

    public boolean ping(URL pingURL, HttpResult result, long timeout) {
        return this.ping(pingURL, null, result, timeout);
    }

    public boolean ping(URL pingURL, Map<String, String> requestProperties, HttpResult result) {
        return this.ping(pingURL, requestProperties, result, 0L);
    }

    public boolean ping(URL pingURL, Map<String, String> requestProperties, HttpResult result, long timeout) {
        HttpResult responseResult = this.testConnectivity(pingURL, requestProperties, timeout);
        result.responseBody = responseResult.responseBody;
        result.responseCode = responseResult.responseCode;
        result.responseMessage = responseResult.responseMessage;
        return this.isAvailable(responseResult);
    }

    private HttpResult testConnectivity(URL url, Map<String, String> requestProperties, long timeout) {
        HttpRequest connection = new HttpRequest(url, timeout);
        connection.setLogger(this.getLogger());
        if (requestProperties != null) {
            for (Map.Entry<String, String> requestProperty : requestProperties.entrySet()) {
                String key = requestProperty.getKey();
                String value = requestProperty.getValue();
                connection.addRequestProperty(key, value);
            }
        }
        HttpResult responseResult = new HttpResult();
        try {
            org.codehaus.cargo.container.internal.http.HttpResult httpResult = connection.get();
            responseResult.responseBody = httpResult.getResponseBody();
            responseResult.responseCode = httpResult.getResponseCode();
            responseResult.responseMessage = httpResult.getResponseMessage();
        }
        catch (IOException e) {
            responseResult.responseCode = -1;
            responseResult.responseMessage = e.toString();
        }
        return responseResult;
    }

    private boolean isAvailable(HttpResult responseResult) {
        boolean result = responseResult.responseCode >= 200 && responseResult.responseCode < 400 || responseResult.responseCode == 401 || responseResult.responseCode == 403;
        return result;
    }

    public static class HttpResult {
        public int responseCode;
        public String responseMessage;
        public String responseBody;
    }
}

