/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.AbstractLocalContainer;
import org.codehaus.cargo.container.spi.jvm.DefaultJvmLauncherFactory;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.container.spi.jvm.JvmLauncherFactory;
import org.codehaus.cargo.container.spi.jvm.JvmLauncherRequest;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractInstalledLocalContainer
extends AbstractLocalContainer
implements InstalledLocalContainer {
    private static Pattern classpathQuotedPattern = Pattern.compile("-(classpath|cp)\\s+\"([^\"]*)\"");
    private static Pattern classpathPattern = Pattern.compile("-(classpath|cp)\\s+([^\\s+\"]*)\\s+");
    private static Pattern classpathFinalPattern = Pattern.compile("-(classpath|cp)\\s+([^\\s+\"]*)");
    private Map<String, String> systemProperties;
    private List<String> extraClasspath;
    private List<String> sharedClasspath;
    private String home;
    private HttpUtils httpUtils;
    private ResourceUtils resourceUtils = new ResourceUtils();
    private JvmLauncherFactory jvmLauncherFactory;
    private JvmLauncher jvmStartLauncher;
    private int jvmMajorVersion = -1;

    public AbstractInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
        this.httpUtils = new HttpUtils();
        this.jvmLauncherFactory = new DefaultJvmLauncherFactory();
        this.extraClasspath = new ArrayList<String>();
        this.sharedClasspath = new ArrayList<String>();
        this.systemProperties = new HashMap<String, String>();
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.resourceUtils.setLogger(logger);
        this.httpUtils.setLogger(logger);
    }

    protected final HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    @Override
    public void setHome(String home) {
        this.home = home;
    }

    @Override
    public void setSystemProperties(Map<String, String> properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(properties);
        this.systemProperties = props;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public void setExtraClasspath(String[] classpath) {
        this.extraClasspath.clear();
        this.extraClasspath.addAll(Arrays.asList(classpath));
    }

    @Override
    public String[] getExtraClasspath() {
        return this.extraClasspath.toArray(new String[this.extraClasspath.size()]);
    }

    @Override
    public void setSharedClasspath(String[] classpath) {
        this.sharedClasspath.clear();
        this.sharedClasspath.addAll(Arrays.asList(classpath));
    }

    @Override
    public String[] getSharedClasspath() {
        return this.sharedClasspath.toArray(new String[this.sharedClasspath.size()]);
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public JvmLauncherFactory getJvmLauncherFactory() {
        return this.jvmLauncherFactory;
    }

    @Override
    public void setJvmLauncherFactory(JvmLauncherFactory jvmLauncherFactory) {
        this.jvmLauncherFactory = jvmLauncherFactory;
    }

    protected abstract void doStart(JvmLauncher var1) throws Exception;

    protected abstract void doStop(JvmLauncher var1) throws Exception;

    @Override
    protected void startInternal() throws Exception {
        this.jvmStartLauncher = this.createJvmLauncher(true);
        if (this.getOutput() != null) {
            this.jvmStartLauncher.setAppendOutput(this.isAppend());
        }
        this.addMemoryArguments(this.jvmStartLauncher);
        this.doStart(this.jvmStartLauncher);
    }

    @Override
    protected void stopInternal() throws Exception {
        this.doStop(this.createJvmLauncher(false));
    }

    @Override
    protected final void forceStopInternal() {
        if (this.jvmStartLauncher != null) {
            this.jvmStartLauncher.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JvmLauncher createJvmLauncher(boolean server) {
        JvmLauncher java;
        JvmLauncherRequest request;
        boolean spawned = Boolean.parseBoolean(this.getConfiguration().getPropertyValue("cargo.process.spawn"));
        if (this.jvmMajorVersion == -1) {
            request = new JvmLauncherRequest(false, this);
            java = this.jvmLauncherFactory.createJvmLauncher(request);
            this.setJvmToLaunchContainerIn(java);
            try {
                File jvmVersionFile = File.createTempFile("cargo-jvm-version-", ".txt");
                java.setOutputFile(jvmVersionFile);
                java.setAppendOutput(true);
                java.setMainClass("-version");
                java.execute();
                StringBuilder javaVersionOutput = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new FileReader(jvmVersionFile));){
                    String line = br.readLine();
                    while (line != null) {
                        if (line.startsWith("java version \"") || line.startsWith("openjdk version \"")) {
                            this.jvmMajorVersion = JdkUtils.parseMajorJavaVersion(line.substring(line.indexOf(34) + 1));
                            break;
                        }
                        javaVersionOutput.append(line);
                        javaVersionOutput.append(FileHandler.NEW_LINE);
                        line = br.readLine();
                    }
                    if (this.jvmMajorVersion == -1) {
                        throw new IOException("Can't read JVM version from output: " + javaVersionOutput);
                    }
                }
                finally {
                    jvmVersionFile.delete();
                }
            }
            catch (IOException e) {
                throw new CargoException("Cannot read JVM version, please check that the provided execution [" + java.getCommandLine() + "] is valid", (Throwable)e);
            }
        }
        request = new JvmLauncherRequest(server, this, spawned);
        java = this.jvmLauncherFactory.createJvmLauncher(request);
        java.setWorkingDirectory(new File(this.getFileHandler().getAbsolutePath(this.getConfiguration().getHome())));
        if (this.getOutput() == null) {
            java.setOutputLogger(this.getLogger(), this.getClass().getName());
        } else {
            File outputFile = new File(this.getOutput());
            this.getFileHandler().mkdirs(outputFile.getAbsoluteFile().getParent());
            java.setOutputFile(outputFile);
            java.setAppendOutput(true);
        }
        this.setJvmToLaunchContainerIn(java);
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        this.addRuntimeArgs(java);
        this.addJvmArgs(java, server);
        if (server) {
            this.addStartJvmArgs(java);
        }
        this.addSpawn(java);
        java.setTimeout(this.getTimeout());
        return java;
    }

    protected String getJavaHome() {
        String javaHome = this.getConfiguration().getPropertyValue("cargo.java.home");
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        return javaHome;
    }

    public void setJvmToLaunchContainerIn(JvmLauncher java) {
        String javaHome = this.getJavaHome();
        if (javaHome != null) {
            String binDir = this.getFileHandler().append(javaHome, "bin");
            String javaPath = this.getFileHandler().append(binDir, "java");
            if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows")) {
                javaPath = javaPath + ".exe";
            }
            java.setJvm(javaPath);
        }
    }

    private void addSystemProperties(JvmLauncher java) {
        for (Map.Entry<String, String> systemProperty : this.getSystemProperties().entrySet()) {
            java.setSystemProperty(systemProperty.getKey(), systemProperty.getValue());
        }
    }

    protected final void addToolsJarToClasspath(JvmLauncher java) throws FileNotFoundException {
        if (!JdkUtils.isOSX() && this.jvmMajorVersion < 9) {
            java.addClasspathEntries(JdkUtils.getToolsJar(this.getJavaHome()));
        }
    }

    protected void addExtraClasspath(JvmLauncher java) {
        for (String extraClasspathItem : this.extraClasspath) {
            java.addClasspathEntries(extraClasspathItem);
            this.getLogger().debug("Adding [" + extraClasspathItem + "] to execution classpath", this.getClass().getName());
        }
    }

    protected void addRuntimeArgs(JvmLauncher java) {
        String runtimeArgs = this.getConfiguration().getPropertyValue("cargo.runtime.args");
        if (runtimeArgs != null) {
            runtimeArgs = runtimeArgs.replace('\n', ' ');
            runtimeArgs = runtimeArgs.replace('\r', ' ');
            runtimeArgs = runtimeArgs.replace('\t', ' ');
            java.addAppArgumentLine(runtimeArgs);
        }
    }

    private void addJvmArgs(JvmLauncher java, boolean server) {
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        String startJmvmargs = null;
        if (server) {
            startJmvmargs = this.getConfiguration().getPropertyValue("cargo.start.jvmargs");
        }
        if (jvmargs != null) {
            jvmargs = jvmargs.replace('\n', ' ');
            jvmargs = jvmargs.replace('\r', ' ');
            if ((jvmargs = jvmargs.replace('\t', ' ')) == null || !jvmargs.contains("-Xms")) {
                java.addJvmArguments("-Xms128m");
            }
            if (jvmargs == null || !jvmargs.contains("-Xmx")) {
                java.addJvmArguments("-Xmx512m");
            }
            if (this.jvmMajorVersion >= 8) {
                jvmargs.replaceAll("\\s*-XX:PermSize\\d+\\w\\s*", " ");
                jvmargs.replaceAll("\\s*-XX:MaxPermSize\\d+\\w\\s*", " ");
            } else {
                if (jvmargs == null || !jvmargs.contains("-XX:PermSize")) {
                    java.addJvmArguments("-XX:PermSize=48m");
                }
                if (jvmargs == null || !jvmargs.contains("-XX:MaxPermSize")) {
                    java.addJvmArguments("-XX:MaxPermSize=128m");
                }
            }
            if (startJmvmargs != null) {
                if (startJmvmargs.contains("-Xms")) {
                    jvmargs.replaceAll("\\s*-Xms\\d+\\w\\s*", " ");
                }
                if (startJmvmargs.contains("-Xmx")) {
                    jvmargs.replaceAll("\\s*-Xmx\\d+\\w\\s*", " ");
                }
                if (startJmvmargs.contains("-XX:PermSize")) {
                    jvmargs.replaceAll("\\s*-XX:PermSize\\d+\\w\\s*", " ");
                }
                if (startJmvmargs.contains("-XX:MaxPermSize")) {
                    jvmargs.replaceAll("\\s*-XX:MaxPermSize\\d+\\w\\s*", " ");
                }
            }
            jvmargs = this.addJvmClasspathArguments(java, jvmargs);
            java.addJvmArgumentLine(jvmargs);
        }
    }

    private void addStartJvmArgs(JvmLauncher java) {
        String startJmvmargs = this.getConfiguration().getPropertyValue("cargo.start.jvmargs");
        if (startJmvmargs != null) {
            startJmvmargs = startJmvmargs.replace('\n', ' ');
            startJmvmargs = startJmvmargs.replace('\r', ' ');
            startJmvmargs = startJmvmargs.replace('\t', ' ');
            if (this.jvmMajorVersion >= 8) {
                startJmvmargs.replaceAll("\\s*-XX:PermSize\\d+\\w\\s*", " ");
                startJmvmargs.replaceAll("\\s*-XX:MaxPermSize\\d+\\w\\s*", " ");
            }
            startJmvmargs = this.addJvmClasspathArguments(java, startJmvmargs);
            java.addJvmArgumentLine(startJmvmargs);
        }
    }

    private String addJvmClasspathArguments(JvmLauncher java, String jvmArgs) {
        String jvmargs = jvmArgs;
        if (jvmargs.contains("-classpath") || jvmargs.contains("-cp")) {
            String classpath = null;
            Matcher classpathQuotedMatcher = classpathQuotedPattern.matcher(jvmargs);
            if (classpathQuotedMatcher.find()) {
                classpath = classpathQuotedMatcher.group(2);
                jvmargs = classpathQuotedMatcher.replaceAll(" ");
            } else {
                Matcher classpathMatcher = classpathPattern.matcher(jvmargs);
                if (classpathMatcher.find()) {
                    classpath = classpathMatcher.group(2);
                    jvmargs = classpathMatcher.replaceAll(" ");
                } else {
                    Matcher classpathFinalMatcher = classpathFinalPattern.matcher(jvmargs);
                    if (classpathFinalMatcher.find()) {
                        classpath = classpathFinalMatcher.group(2);
                        jvmargs = classpathFinalMatcher.replaceAll("");
                    }
                }
            }
            if (classpath == null) {
                throw new ContainerException("The JVM arguments contains a classpath entry but none of the classpath matchers matched");
            }
            this.getLogger().debug("Adding [" + classpath + "] to execution classpath", this.getClass().getName());
            java.addClasspathEntries(classpath.split(File.pathSeparator));
        }
        return jvmargs;
    }

    protected void addMemoryArguments(JvmLauncher java) {
        String jvmArgs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        String startJvmargs = this.getConfiguration().getPropertyValue("cargo.start.jvmargs");
        if (startJvmargs != null) {
            jvmArgs = jvmArgs == null ? startJvmargs : jvmArgs + " " + startJvmargs;
        }
        if (jvmArgs == null || !jvmArgs.contains("-Xms")) {
            java.addJvmArguments("-Xms128m");
        }
        if (jvmArgs == null || !jvmArgs.contains("-Xmx")) {
            java.addJvmArguments("-Xmx512m");
        }
        if (this.jvmMajorVersion < 8) {
            if (jvmArgs == null || !jvmArgs.contains("-XX:PermSize")) {
                java.addJvmArguments("-XX:PermSize=48m");
            }
            if (jvmArgs == null || !jvmArgs.contains("-XX:MaxPermSize")) {
                java.addJvmArguments("-XX:MaxPermSize=128m");
            }
        }
    }

    private void addSpawn(JvmLauncher java) {
        boolean spawnProcess = Boolean.parseBoolean(this.getConfiguration().getPropertyValue("cargo.process.spawn"));
        if (spawnProcess) {
            if (this.getOutput() == null) {
                java.setSpawn(spawnProcess);
            } else {
                this.getLogger().warn("Process cannot be spawned unless output is null", this.getClass().getName());
            }
        }
    }

    @Override
    protected void verify() {
        super.verify();
        this.verifyHome();
    }

    private void verifyHome() {
        if (this.getHome() == null) {
            throw new ContainerException("You must set the mandatory [home] property");
        }
        if (!this.getFileHandler().isDirectory(this.getHome())) {
            throw new ContainerException("[" + this.getHome() + "] is not a directory. It must point to the container home directory.");
        }
    }

    @Override
    public ContainerType getType() {
        return ContainerType.INSTALLED;
    }

    @Override
    public void addExtraClasspath(String location) {
        this.ifPresentAddPathToList(location, this.extraClasspath);
    }

    @Override
    public void addSharedClasspath(String location) {
        this.ifPresentAddPathToList(location, this.sharedClasspath);
    }

    public void ifPresentAddPathToList(String location, List<String> list) {
        if (location == null || !this.getFileHandler().exists(location) || this.getFileHandler().isDirectory(location)) {
            throw new IllegalArgumentException("Invalid file path: " + location);
        }
        list.add(location);
    }
}

