/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.http.writer;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.cargo.container.internal.http.MultipartFormContentType;

public class MultipartFormWriter
implements AutoCloseable {
    private static final String NEWLINE = "\r\n";
    private static final String PREFIX = "--";
    private DataOutputStream out = null;
    private String boundary = null;

    public MultipartFormWriter(MultipartFormContentType contentType, OutputStream os) {
        if (os == null) {
            throw new IllegalArgumentException("Output stream is required.");
        }
        this.out = new DataOutputStream(os);
        this.boundary = contentType.getBoundary();
    }

    public void writeField(String name, String value) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"");
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes(NEWLINE);
        if (value != null) {
            this.out.writeBytes(value);
        }
        this.out.writeBytes(NEWLINE);
        this.out.flush();
    }

    public void writeFile(String name, File file) throws IOException {
        this.writeFile(name, file, "application/octet-stream");
    }

    public void writeFile(String name, File file, String mimeType) throws IOException {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File cannot be a directory.");
        }
        if (mimeType == null || mimeType.trim().isEmpty()) {
            throw new IllegalArgumentException("File content type cannot be null");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.out.writeBytes(PREFIX);
            this.out.writeBytes(this.boundary);
            this.out.writeBytes(NEWLINE);
            this.out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.getName() + "\"");
            this.out.writeBytes(NEWLINE);
            this.out.writeBytes("Content-Type: " + mimeType);
            this.out.writeBytes(NEWLINE);
            this.out.writeBytes(NEWLINE);
            byte[] data = new byte[1024];
            int r = 0;
            while ((r = ((InputStream)fileInputStream).read(data, 0, data.length)) != -1) {
                this.out.write(data, 0, r);
            }
            this.out.writeBytes(NEWLINE);
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(NEWLINE);
        this.out.flush();
        this.out.close();
    }
}

