/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.codehaus.cargo.util.Base64;
import org.codehaus.cargo.util.log.LoggedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils
extends LoggedObject {
    public final boolean ping(URL pingURL) {
        return this.isAvailable(this.testConnectivity(pingURL, null, 0L));
    }

    public final boolean ping(URL pingURL, HttpResult result) {
        return this.ping(pingURL, null, result);
    }

    public final boolean ping(URL pingURL, HttpResult result, long timeout) {
        return this.ping(pingURL, null, result, timeout);
    }

    public final boolean ping(URL pingURL, Map<String, String> requestProperties, HttpResult result) {
        return this.ping(pingURL, requestProperties, result, 0L);
    }

    public final boolean ping(URL pingURL, Map<String, String> requestProperties, HttpResult result, long timeout) {
        HttpResult responseResult = this.testConnectivity(pingURL, requestProperties, timeout);
        result.responseBody = responseResult.responseBody;
        result.responseCode = responseResult.responseCode;
        result.responseMessage = responseResult.responseMessage;
        return this.isAvailable(responseResult);
    }

    private HttpResult testConnectivity(URL url, Map<String, String> requestProperties, long timeout) {
        HttpResult result = new HttpResult();
        try {
            HttpURLConnection connection;
            if (url.getProtocol().equalsIgnoreCase("https")) {
                TrustManager[] trustAll = new TrustManager[]{new PermissiveTrustManager()};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAll, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                connection = (HttpsURLConnection)url.openConnection();
                PermissiveHostnameVerifier verifyAll = new PermissiveHostnameVerifier();
                ((HttpsURLConnection)connection).setHostnameVerifier(verifyAll);
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                userInfo = Base64.encode((String)userInfo);
                connection.setRequestProperty("Authorization", "Basic " + userInfo);
            }
            connection.setRequestProperty("Connection", "close");
            if (timeout != 0L) {
                connection.setReadTimeout((int)timeout);
                connection.setConnectTimeout((int)timeout);
            }
            if (requestProperties != null) {
                for (Map.Entry<String, String> requestProperty : requestProperties.entrySet()) {
                    String key = requestProperty.getKey();
                    String value = requestProperty.getValue();
                    connection.setRequestProperty(key, value);
                    this.getLogger().debug("Added property [" + key + "] = [" + value + "]", ((Object)((Object)this)).getClass().getName());
                }
            }
            connection.connect();
            result.responseBody = this.readFully(connection);
            connection.disconnect();
            result.responseCode = connection.getResponseCode();
            result.responseMessage = connection.getResponseMessage();
        }
        catch (IOException e) {
            result.responseCode = -1;
            result.responseMessage = e.toString();
        }
        catch (NoSuchAlgorithmException e) {
            result.responseCode = -1;
            result.responseMessage = e.toString();
        }
        catch (KeyManagementException e) {
            result.responseCode = -1;
            result.responseMessage = e.toString();
        }
        this.getLogger().debug("Pinged [" + url + "], result = [" + result.responseCode + "]", ((Object)((Object)this)).getClass().getName());
        return result;
    }

    private boolean isAvailable(HttpResult responseResult) {
        boolean result = responseResult.responseCode >= 200 && responseResult.responseCode < 400 || responseResult.responseCode == 401 || responseResult.responseCode == 403;
        return result;
    }

    private String readFully(HttpURLConnection connection) throws IOException {
        String responseBody = "";
        if (connection.getContentLength() != 0) {
            try {
                InputStream in = connection.getInputStream();
                if (in != null) {
                    responseBody = this.readStreamData(in);
                }
            }
            catch (IOException e) {
                InputStream in = connection.getErrorStream();
                if (in != null) {
                    responseBody = this.readStreamData(in);
                }
                throw e;
            }
        }
        return responseBody;
    }

    private String readStreamData(InputStream stream) throws IOException {
        int n;
        StringBuilder body = new StringBuilder();
        byte[] buf = new byte[256];
        while ((n = stream.read(buf)) != -1) {
            body.append(new String(buf, 0, n));
        }
        return body.toString();
    }

    private class PermissiveHostnameVerifier
    implements HostnameVerifier {
        private PermissiveHostnameVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private class PermissiveTrustManager
    implements X509TrustManager {
        private PermissiveTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    public static class HttpResult {
        public int responseCode;
        public String responseMessage;
        public String responseBody;
    }
}

