/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import org.codehaus.cargo.container.ContainerException;

public class JdkUtils {
    public final File getToolsJar() throws FileNotFoundException {
        String javaHome = System.getProperty("java.home");
        File toolsJar = this.getToolsJar(javaHome);
        if (!toolsJar.isFile()) {
            throw new FileNotFoundException(toolsJar.getAbsolutePath());
        }
        return toolsJar;
    }

    public final File getToolsJar(String javaHome) {
        File jdkHome = new File(javaHome).getAbsoluteFile();
        if (jdkHome.getName().equals("jre")) {
            jdkHome = jdkHome.getParentFile();
        }
        File libDir = new File(jdkHome, "lib");
        File toolsJar = new File(libDir, "tools.jar");
        return toolsJar;
    }

    public final boolean isOSX() {
        return System.getProperty("mrj.version") != null;
    }

    public void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new ContainerException("Interruption during sleep", e);
        }
    }
}

