/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.container.spi.AbstractContainer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public abstract class AbstractLocalContainer
extends AbstractContainer
implements LocalContainer {
    private String output;
    private boolean append = false;
    private long timeout = 120000L;
    private LocalConfiguration configuration;
    private State state = State.UNKNOWN;
    private FileHandler fileHandler;

    public AbstractLocalContainer(LocalConfiguration configuration) {
        this.configuration = configuration;
        this.fileHandler = new DefaultFileHandler();
    }

    public final void setOutput(String output) {
        this.output = output;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public final String getOutput() {
        return this.output;
    }

    public final boolean isAppend() {
        return this.append;
    }

    protected void verify() {
        this.getConfiguration().applyPortOffset();
    }

    protected abstract void startInternal() throws Exception;

    protected abstract void stopInternal() throws Exception;

    protected void forceStopInternal() {
    }

    protected void executePostStartTasks() throws Exception {
    }

    public final void start() {
        this.verify();
        this.getConfiguration().configure(this);
        for (Map.Entry<String, String> property : this.getConfiguration().getProperties().entrySet()) {
            if (!property.getKey().endsWith(".port") || property.getValue() == null) continue;
            try {
                int port = Integer.parseInt(property.getValue());
                if (this.isPortShutdown(port, 0)) continue;
                throw new ContainerException("Port number " + property.getValue() + " (defined with the property " + property.getKey() + ") is in use. " + "Please free it on the system or set it to a different port " + "in the container's configuration.");
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        this.getLogger().info(this.getName() + " starting...", this.getClass().getName());
        this.setState(State.STARTING);
        try {
            this.startInternal();
            if (this.getTimeout() != 0L) {
                this.waitForCompletion(true);
            }
            this.executePostStartTasks();
            this.setState(State.STARTED);
            this.getLogger().info(this.getName() + " started on port [" + this.getConfiguration().getPropertyValue("cargo.servlet.port") + "]", this.getClass().getName());
        }
        catch (Exception e) {
            this.setState(State.UNKNOWN);
            throw new ContainerException("Failed to start the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput() + "] file " + "containing the container logs for more details."), e);
        }
        finally {
            this.getConfiguration().revertPortOffset();
        }
    }

    public final void stop() {
        this.verify();
        this.getLogger().info(this.getName() + " is stopping...", this.getClass().getName());
        this.setState(State.STOPPING);
        boolean isAppend = this.isAppend();
        try {
            this.setAppend(true);
            this.stopInternal();
            if (this.getTimeout() != 0L) {
                this.waitForCompletion(false);
            }
            this.forceStopInternal();
        }
        catch (Exception e) {
            this.setState(State.UNKNOWN);
            throw new ContainerException("Failed to stop the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput() + "] file " + "containing the container logs for more details."), e);
        }
        finally {
            this.setAppend(isAppend);
        }
        this.setState(State.STOPPED);
        this.getLogger().info(this.getName() + " is stopped", this.getClass().getName());
    }

    public void restart() {
        try {
            this.stop();
        }
        catch (Throwable t) {
            this.getLogger().info("The stop phase of the restart action has failed: " + t.toString(), this.getClass().getName());
        }
        this.start();
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        LocalConfiguration config = this.getConfiguration();
        if (waitForStarting) {
            URLDeployableMonitor monitor = new URLDeployableMonitor(ContainerUtils.getCPCURL(config), this.getTimeout(), "Cargo Ping Component used to verify if the container is started.");
            monitor.setLogger(this.getLogger());
            DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
            watchdog.setLogger(this.getLogger());
            watchdog.watch(waitForStarting);
        } else {
            long deadline = System.currentTimeMillis() + this.getTimeout();
            int connectTimeout = 0;
            for (Map.Entry<String, String> property : this.getConfiguration().getProperties().entrySet()) {
                int port;
                if (!property.getKey().endsWith(".port") || property.getValue() == null) continue;
                try {
                    port = Integer.parseInt(property.getValue());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (port < 1 || port > 65535) continue;
                this.waitForPortShutdown(port, connectTimeout, deadline);
                this.getLogger().debug("\tPort " + port + " is shutdown", this.getClass().getName());
                connectTimeout = 250;
            }
            Thread.sleep(5000L);
        }
    }

    private void waitForPortShutdown(int port, int connectTimeout, long deadline) throws InterruptedException {
        this.getLogger().debug("Waiting for port " + port + " to shutdown, deadline " + deadline, this.getClass().getName());
        while (!this.isPortShutdown(port, connectTimeout)) {
            if (System.currentTimeMillis() > deadline) {
                throw new ContainerException("Server port " + port + " did not shutdown within the timeout period [" + this.getTimeout() + "]");
            }
            Thread.sleep(1000L);
        }
    }

    public void setConfiguration(LocalConfiguration configuration) {
        this.configuration = configuration;
    }

    public LocalConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPortShutdown(int port, int connectTimeout) {
        Socket s = new Socket();
        try {
            try {
                this.getLogger().debug("\tConnection attempt with socket " + s + ", current time is " + System.currentTimeMillis(), this.getClass().getName());
                s.bind(null);
                s.connect(new InetSocketAddress("localhost", port), connectTimeout);
                this.getLogger().debug("\tSocket " + s + " for port " + port + " managed to connect", this.getClass().getName());
                try {
                    s.shutdownOutput();
                }
                catch (IOException e) {
                    this.getLogger().debug("\tFailed to shutdown output for socket " + s + ": " + e, this.getClass().getName());
                }
                try {
                    s.shutdownInput();
                }
                catch (IOException e) {
                    this.getLogger().debug("\tFailed to shutdown input for socket " + s + ": " + e, this.getClass().getName());
                }
                this.getLogger().debug("\tSocket " + s + " for port " + port + " shutdown", this.getClass().getName());
            }
            catch (IOException ignored) {
                boolean bl = true;
                Object var7_8 = null;
                try {}
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                    s = null;
                    System.gc();
                    throw throwable;
                }
                try {}
                catch (IOException e) {
                    this.getLogger().debug("\tFailed to close socket " + s + ": " + e, this.getClass().getName());
                    Object var10_14 = null;
                    this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                    s = null;
                    System.gc();
                    return bl;
                }
                s.close();
                Object var10_13 = null;
                this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                s = null;
                System.gc();
                return bl;
            }
            Object var7_7 = null;
            try {
                try {
                    s.close();
                }
                catch (IOException e) {
                    this.getLogger().debug("\tFailed to close socket " + s + ": " + e, this.getClass().getName());
                    Object var10_11 = null;
                    this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                    s = null;
                    System.gc();
                    return false;
                }
                Object var10_10 = null;
                this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                s = null;
                System.gc();
                return false;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                s = null;
                System.gc();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {}
            catch (Throwable throwable2) {
                Object var10_18 = null;
                this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                s = null;
                System.gc();
                throw throwable2;
            }
            try {}
            catch (IOException e) {
                this.getLogger().debug("\tFailed to close socket " + s + ": " + e, this.getClass().getName());
                Object var10_17 = null;
                this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                s = null;
                System.gc();
                throw throwable;
            }
            s.close();
            Object var10_16 = null;
            this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
            s = null;
            System.gc();
            throw throwable;
        }
    }
}

