/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.spi.configuration.ContainerConfiguration;
import org.codehaus.cargo.util.log.LoggedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfiguration
extends LoggedObject
implements ContainerConfiguration,
Configuration {
    private Map<String, String> properties = new HashMap<String, String>();

    public AbstractConfiguration() {
        this.setProperty("cargo.protocol", "http");
        this.setProperty("cargo.hostname", "localhost");
        this.setProperty("cargo.servlet.port", "8080");
    }

    @Override
    public final void setProperty(String name, String value) {
        this.getLogger().debug("Setting property [" + name + "] = [" + value + "]", this.getClass().getName());
        this.properties.put(name, value);
    }

    @Override
    public final Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public final String getPropertyValue(String name) {
        String systemProperty = System.getProperties().getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        return this.properties.get(name);
    }

    @Override
    public void verify() {
        this.verifyServletPortProperty();
    }

    private void verifyServletPortProperty() {
        try {
            Integer.parseInt(this.getPropertyValue("cargo.servlet.port"));
        }
        catch (NumberFormatException e) {
            throw new ContainerException("Invalid port number [" + this.getPropertyValue("cargo.servlet.port") + "] for property " + "cargo.servlet.port" + ". The port value must be an integer", e);
        }
    }
}

