/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.spi.configuration.AbstractLocalConfiguration;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandaloneLocalConfiguration
extends AbstractLocalConfiguration
implements StandaloneLocalConfiguration {
    private Map<String, Map<FileHandler.XmlReplacement, String>> xmlReplacements;

    public AbstractStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.logging", LoggingLevel.MEDIUM.getLevel());
        this.setProperty("cargo.standalone.ignoreNonExistingProperties", "false");
        this.xmlReplacements = new HashMap<String, Map<FileHandler.XmlReplacement, String>>();
    }

    protected void performXmlReplacements(LocalContainer container) {
        boolean ignoreNonExistingProperties = Boolean.valueOf(this.getPropertyValue("cargo.standalone.ignoreNonExistingProperties"));
        for (Map.Entry<String, Map<FileHandler.XmlReplacement, String>> xmlReplacements : this.xmlReplacements.entrySet()) {
            HashMap<FileHandler.XmlReplacement, String> replacements = new HashMap<FileHandler.XmlReplacement, String>();
            for (Map.Entry<FileHandler.XmlReplacement, String> xmlReplacement : xmlReplacements.getValue().entrySet()) {
                String value = container.getConfiguration().getPropertyValue(xmlReplacement.getValue());
                if (value != null) {
                    replacements.put(xmlReplacement.getKey(), value);
                    continue;
                }
                replacements.put(xmlReplacement.getKey(), xmlReplacement.getValue());
            }
            if (replacements.isEmpty()) continue;
            String destinationFile = this.getFileHandler().append(container.getConfiguration().getHome(), xmlReplacements.getKey());
            this.getFileHandler().replaceInXmlFile(destinationFile, replacements, ignoreNonExistingProperties);
        }
    }

    protected void setupConfigurationDir() throws IOException {
        String timestampFile = this.getFileHandler().append(this.getHome(), ".cargo");
        if (!(this.getFileHandler().exists(timestampFile) || this.getFileHandler().exists(this.getHome()) && this.getFileHandler().isDirectoryEmpty(this.getHome()) || !this.getFileHandler().exists(this.getHome()))) {
            throw new ContainerException("Invalid configuration dir [" + this.getHome() + "]. " + "When using standalone configurations, the configuration dir must point to an " + "empty directory. Note that everything in that dir will get deleted by Cargo.");
        }
        this.getFileHandler().delete(this.getHome());
        this.getFileHandler().mkdirs(this.getHome());
        this.getFileHandler().createFile(timestampFile);
    }

    protected void addXmlReplacement(String filename, String xpathExpression, String configurationPropertyName) {
        this.addXmlReplacement(filename, xpathExpression, null, configurationPropertyName);
    }

    protected void addXmlReplacement(String filename, String xpathExpression, String attributeName, String configurationPropertyName) {
        Map<FileHandler.XmlReplacement, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements == null) {
            fileReplacements = new HashMap<FileHandler.XmlReplacement, String>();
            this.xmlReplacements.put(filename, fileReplacements);
        }
        fileReplacements.put(new FileHandler.XmlReplacement(xpathExpression, attributeName), configurationPropertyName);
    }

    protected void removeXmlReplacement(String filename, String xpathExpression) {
        this.removeXmlReplacement(filename, xpathExpression, null);
    }

    protected void removeXmlReplacement(String filename, String xpathExpression, String attributeName) {
        Map<FileHandler.XmlReplacement, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements != null) {
            fileReplacements.remove(new FileHandler.XmlReplacement(xpathExpression, attributeName));
            if (fileReplacements.isEmpty()) {
                this.xmlReplacements.remove(filename);
            }
        }
    }

    @Override
    public void verify() {
        super.verify();
        this.verifyLogging();
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        try {
            LoggingLevel.toLevel(level);
        }
        catch (IllegalArgumentException e) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", " + "\"high\"}");
        }
    }

    @Override
    public ConfigurationType getType() {
        return ConfigurationType.STANDALONE;
    }

    @Override
    protected void configureFiles(FilterChain filterChain, LocalContainer container) {
        this.performXmlReplacements(container);
        super.configureFiles(filterChain, container);
    }

    protected void replaceInFile(String file, Map<String, String> replacements, String encoding) throws CargoException {
        boolean ignoreNonExistingProperties = Boolean.valueOf(this.getPropertyValue("cargo.standalone.ignoreNonExistingProperties"));
        if (replacements.isEmpty()) {
            return;
        }
        String path = this.getHome() + "/" + file;
        this.getFileHandler().replaceInFile(path, replacements, encoding, ignoreNonExistingProperties);
    }
}

