/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployer;

import java.util.List;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.util.log.LoggedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployer
extends LoggedObject
implements Deployer {
    public AbstractDeployer(Container container) {
        this.setLogger(container.getLogger());
    }

    public void deploy(List<Deployable> deployables) {
        for (Deployable deployable : deployables) {
            this.deploy(deployable);
        }
    }

    @Override
    public void deploy(Deployable deployable, DeployableMonitor monitor) {
        try {
            this.deploy(deployable);
        }
        catch (Throwable t) {
            this.getLogger().info("The deployment has failed: " + t.toString(), this.getClass().getName());
        }
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForAvailability();
    }

    @Override
    public void undeploy(Deployable deployable, DeployableMonitor monitor) {
        try {
            this.undeploy(deployable);
        }
        catch (Throwable t) {
            this.getLogger().info("The undeployment has failed: " + t.toString(), this.getClass().getName());
        }
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForUnavailability();
    }

    @Override
    public void redeploy(Deployable deployable, DeployableMonitor monitor) {
        try {
            this.undeploy(deployable);
        }
        catch (Throwable t) {
            this.getLogger().info("The undeployment phase of the redeploy action has failed: " + t.toString(), this.getClass().getName());
        }
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForUnavailability();
        this.deploy(deployable, monitor);
    }

    @Override
    public void start(Deployable deployable, DeployableMonitor monitor) {
        this.start(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForAvailability();
    }

    @Override
    public void stop(Deployable deployable, DeployableMonitor monitor) {
        this.redeploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForUnavailability();
    }

    @Override
    public void deploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    @Override
    public void start(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    @Override
    public void stop(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    @Override
    public void undeploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    @Override
    public void redeploy(Deployable deployable) {
        try {
            this.undeploy(deployable);
        }
        catch (Throwable t) {
            this.getLogger().info("The undeployment phase of the redeploy action has failed: " + t.toString(), this.getClass().getName());
        }
        this.deploy(deployable);
    }
}

