/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.installer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Untar;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.installer.Installer;
import org.codehaus.cargo.container.installer.Proxy;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

public class ZipURLInstaller
extends LoggedObject
implements Installer {
    private static final String[] ARCHIVE_ENDINGS = new String[]{".zip", ".tgz", ".tar", ".bz2", ".tar.gz"};
    private static final int BUFFER_CHUNK_SIZE = 262144;
    private URL remoteLocation;
    private String downloadDir;
    private String extractDir;
    private Proxy proxy;
    private AntUtils antUtils;
    private FileHandler fileHandler;

    public ZipURLInstaller(URL remoteLocation) {
        this(remoteLocation, null, null);
    }

    public ZipURLInstaller(URL remoteLocation, String downloadDir, String extractDir) {
        this.remoteLocation = remoteLocation;
        this.downloadDir = downloadDir;
        this.extractDir = extractDir;
        this.fileHandler = new DefaultFileHandler();
        this.antUtils = new AntUtils();
    }

    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public void setExtractDir(String extractDir) {
        this.extractDir = extractDir;
    }

    public String getDownloadDir() {
        if (this.downloadDir == null) {
            return this.getFileHandler().getTmpPath("installs");
        }
        return this.downloadDir;
    }

    public String getDownloadFile() {
        return this.getFileHandler().append(this.getDownloadDir(), this.getSourceFileName());
    }

    public String getExtractDir() {
        String extractDir = this.extractDir == null ? this.getFileHandler().getTmpPath("installs") : this.extractDir;
        String name = this.getSourceFileName();
        for (String element : ARCHIVE_ENDINGS) {
            int dotPos = name.lastIndexOf(element);
            if (dotPos <= -1) continue;
            name = name.substring(0, dotPos);
            break;
        }
        return this.getFileHandler().append(extractDir, name);
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    @Override
    public void install() {
        if (!this.isAlreadyExtracted()) {
            this.getLogger().debug("Container [" + this.getSourceFileName() + "] is not yet installed.", this.getClass().getName());
            if (!this.isAlreadyDownloaded()) {
                this.getLogger().debug("Container [" + this.getSourceFileName() + "] is not yet downloaded.", this.getClass().getName());
                this.download();
            }
            try {
                this.getLogger().debug("Container [" + this.getSourceFileName() + "] is downloaded, now unpacking.", this.getClass().getName());
                this.unpack();
            }
            catch (Exception e) {
                this.getLogger().debug("Container [" + this.getSourceFileName() + "] is broken.", this.getClass().getName());
                File sourceFile = new File(this.getDownloadDir(), this.getSourceFileName());
                sourceFile.delete();
                this.download();
                try {
                    this.unpack();
                }
                catch (Exception ee) {
                    throw new ContainerException("Failed to unpack [" + this.getSourceFileName() + "]", ee);
                }
            }
            this.getLogger().debug("Container [" + this.getSourceFileName() + "] is unpacked, now registering.", this.getClass().getName());
            this.registerInstallation();
        } else {
            this.getLogger().debug("Container [" + this.getSourceFileName() + "] is already installed", this.getClass().getName());
            this.getLogger().debug("Using container installation dir [" + this.getExtractDir() + "]", this.getClass().getName());
        }
    }

    public void registerInstallation() {
        File timestampFile = new File(this.getExtractDir(), ".cargo");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(timestampFile));){
            bw.write("Do not remove this file");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAlreadyDownloaded() {
        boolean isDownloaded = false;
        String targetFile = this.getFileHandler().append(this.getDownloadDir(), this.getSourceFileName());
        if (this.getFileHandler().exists(targetFile)) {
            isDownloaded = true;
        }
        return isDownloaded;
    }

    public boolean isAlreadyExtracted() {
        boolean isExtracted = false;
        String timestampFile = this.getFileHandler().append(this.getExtractDir(), ".cargo");
        if (this.getFileHandler().exists(timestampFile)) {
            isExtracted = true;
        }
        return isExtracted;
    }

    @Override
    public String getHome() {
        if (!this.isAlreadyExtracted()) {
            throw new ContainerException("Failed to get container installation home as the container has not yet been installed. Please call install() first.");
        }
        String targetDir = this.getExtractDir();
        String[] files = this.getFileHandler().getChildren(targetDir);
        int nbDirectories = 0;
        String foundDirectory = null;
        for (String file : files) {
            if (!this.getFileHandler().isDirectory(file) || "PaxHeaders.X".equals(this.getFileHandler().getName(file))) continue;
            ++nbDirectories;
            foundDirectory = file;
        }
        String home = nbDirectories != 1 ? targetDir : foundDirectory;
        return home;
    }

    private void unpack() throws IOException {
        File targetDir = new File(this.getExtractDir());
        File sourceFile = new File(this.getDownloadDir(), this.getSourceFileName());
        this.getLogger().info("Installing container [" + sourceFile + "] in [" + targetDir.getPath() + "]", this.getClass().getName());
        Expand expandTask = this.createExpandTask();
        expandTask.setSrc(sourceFile);
        expandTask.setDest(targetDir);
        expandTask.execute();
        if (!targetDir.isDirectory()) {
            throw new IOException("The file [" + sourceFile + "] is broken");
        }
    }

    private Expand createExpandTask() {
        String archivename = this.getSourceFileName().toLowerCase();
        Expand expand = null;
        if (archivename.endsWith(".zip")) {
            expand = (Expand)this.antUtils.createAntTask("unzip");
        } else if (archivename.endsWith(".tar")) {
            expand = (Expand)this.antUtils.createAntTask("untar");
        } else if (archivename.endsWith(".tgz") || archivename.endsWith(".tar.gz")) {
            Untar untar = (Untar)this.antUtils.createAntTask("untar");
            Untar.UntarCompressionMethod compressionMethod = new Untar.UntarCompressionMethod();
            compressionMethod.setValue("gzip");
            untar.setCompression(compressionMethod);
            expand = untar;
        } else if (archivename.endsWith(".bz2")) {
            Untar untar = (Untar)this.antUtils.createAntTask("untar");
            Untar.UntarCompressionMethod compressionMethod = new Untar.UntarCompressionMethod();
            compressionMethod.setValue("bzip2");
            untar.setCompression(compressionMethod);
            expand = untar;
        } else {
            String errorMessage = "Unsupported archive type: [" + archivename + "]";
            this.getLogger().warn(errorMessage, this.getClass().getName());
            throw new IllegalArgumentException(errorMessage);
        }
        return expand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() {
        block10: {
            Map<String, String> previousProperties = null;
            try {
                if (this.proxy != null) {
                    previousProperties = this.proxy.configure();
                }
                this.doDownload();
            }
            catch (Exception e) {
                if (this.proxy != null) {
                    try {
                        this.proxy.clear(previousProperties);
                        this.doDownload();
                        break block10;
                    }
                    catch (Exception ee) {
                        throw new ContainerException("Failed to download [" + this.remoteLocation + "]", ee);
                    }
                }
                throw new ContainerException("Failed to download [" + this.remoteLocation + "]", e);
            }
            finally {
                if (this.proxy != null) {
                    this.proxy.clear(previousProperties);
                }
            }
        }
    }

    protected void doDownload() throws IOException {
        String downloadDir = this.getDownloadDir();
        if (!this.getFileHandler().exists(downloadDir)) {
            this.getFileHandler().mkdirs(downloadDir);
        }
        File targetFile = new File(downloadDir, this.getSourceFileName());
        this.getLogger().info("Downloading container from [" + this.remoteLocation + "] to [" + targetFile + "]", this.getClass().getName());
        URLConnection connection = this.remoteLocation.openConnection();
        connection.addRequestProperty("Accept", "*/*");
        connection.addRequestProperty("Accept-Encoding", "identity");
        connection.setUseCaches(false);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setInstanceFollowRedirects(true);
            String userInfo = this.remoteLocation.getUserInfo();
            if (userInfo != null) {
                connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8)));
            }
        }
        try (InputStream httpStream = connection.getInputStream();
             FileOutputStream fileStream = new FileOutputStream(targetFile);){
            int n;
            byte[] bytes = new byte[262144];
            while ((n = httpStream.read(bytes)) != -1) {
                ((OutputStream)fileStream).write(bytes, 0, n);
            }
        }
        long remoteTimestamp = connection.getLastModified();
        if (remoteTimestamp != 0L) {
            targetFile.setLastModified(remoteTimestamp);
        }
    }

    protected String getSourceFileName() {
        int slashPos = this.remoteLocation.getPath().lastIndexOf(47);
        String name = this.remoteLocation.getPath();
        if (slashPos > -1) {
            name = this.remoteLocation.getPath().substring(slashPos + 1);
        }
        return name;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

