/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.codehaus.cargo.container.internal.http.HttpRequestBodyWriter;
import org.codehaus.cargo.container.internal.http.HttpResult;
import org.codehaus.cargo.util.log.LoggedObject;

public class HttpConnection
extends LoggedObject {
    private URL url;
    private long timeout;
    private Map<String, String> requestProperties;
    private HttpRequestBodyWriter requestBodyWriter;
    private String requestBody;

    public HttpConnection(URL url) {
        this(url, 0L);
    }

    public HttpConnection(URL url, long timeout) {
        this.url = url;
        this.timeout = timeout;
        this.requestProperties = new HashMap<String, String>();
    }

    public void addRequestProperty(String propertyName, String propertyValue) {
        this.requestProperties.put(propertyName, propertyValue);
    }

    public void setRequestBody(HttpRequestBodyWriter requestBody) {
        this.requestBodyWriter = requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setAuthentication(final String username, final String password) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        });
    }

    public HttpResult get() {
        return this.connect("GET");
    }

    public HttpResult post() {
        return this.connect("POST");
    }

    public HttpResult put() {
        return this.connect("PUT");
    }

    public HttpResult delete() {
        return this.connect("DELETE");
    }

    private HttpResult connect(String httpMethod) {
        HttpResult result = new HttpResult();
        try {
            HttpURLConnection connection;
            block27: {
                OutputStream outputStream;
                if (this.url.getProtocol().equalsIgnoreCase("https")) {
                    TrustManager[] trustAll = new TrustManager[]{new PermissiveTrustManager()};
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, trustAll, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    connection = (HttpsURLConnection)this.url.openConnection();
                    PermissiveHostnameVerifier permissiveHostnameVerifier = new PermissiveHostnameVerifier();
                    ((HttpsURLConnection)connection).setHostnameVerifier(permissiveHostnameVerifier);
                } else {
                    connection = (HttpURLConnection)this.url.openConnection();
                }
                connection.setRequestMethod(httpMethod);
                String userInfo = this.url.getUserInfo();
                if (userInfo != null) {
                    userInfo = Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
                    connection.setRequestProperty("Authorization", "Basic " + userInfo);
                }
                connection.setRequestProperty("Connection", "close");
                if (this.timeout != 0L) {
                    connection.setReadTimeout((int)this.timeout);
                    connection.setConnectTimeout((int)this.timeout);
                }
                if (this.requestProperties != null) {
                    for (Map.Entry entry : this.requestProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        connection.setRequestProperty(key, value);
                        this.getLogger().debug("Added property [" + key + "] = [" + value + "]", ((Object)((Object)this)).getClass().getName());
                    }
                }
                if (this.requestBody != null) {
                    connection.setDoOutput(true);
                    outputStream = connection.getOutputStream();
                    try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));){
                        bufferedWriter.write(this.requestBody);
                        break block27;
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }
                if (this.requestBodyWriter != null) {
                    connection.setDoOutput(true);
                    outputStream = connection.getOutputStream();
                    try {
                        this.requestBodyWriter.writeToOutputStream(outputStream);
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }
            }
            connection.connect();
            result.setResponseCode(connection.getResponseCode());
            result.setResponseMessage(connection.getResponseMessage());
            result.setResponseBody(this.readFully(connection));
            connection.disconnect();
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            result.setResponseCode(-1);
            result.setResponseMessage(e.toString());
        }
        this.getLogger().debug("Called [" + this.url + "], result = [" + result.getResponseCode() + "]", ((Object)((Object)this)).getClass().getName());
        return result;
    }

    private String readFully(HttpURLConnection connection) throws IOException {
        String responseBody = "";
        if (connection.getContentLength() != 0) {
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                InputStream in = connection.getInputStream();
                if (in != null) {
                    responseBody = this.readStreamData(in);
                }
            } else {
                InputStream in = connection.getErrorStream();
                if (in != null) {
                    responseBody = this.readStreamData(in);
                }
            }
        }
        return responseBody;
    }

    private String readStreamData(InputStream stream) throws IOException {
        int n;
        StringBuilder body = new StringBuilder();
        byte[] buf = new byte[256];
        while ((n = stream.read(buf)) != -1) {
            body.append(new String(buf, 0, n));
        }
        return body.toString();
    }

    private class PermissiveHostnameVerifier
    implements HostnameVerifier {
        private PermissiveHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private class PermissiveTrustManager
    implements X509TrustManager {
        private PermissiveTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

