/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.http.request;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import org.codehaus.cargo.container.internal.http.HttpConnection;
import org.codehaus.cargo.container.internal.http.HttpResult;

public class HttpFormRequest
extends HttpConnection {
    private static final String CRLF = "\r\n";
    private static final String HYPHENS = "--";
    private static final String BOUNDARY_VALUE = "CargoBoundary";
    private static final String BOUNDARY_LEFT = "--CargoBoundary";
    private static final String BOUNDARY_BOTH = "--CargoBoundary--";

    public HttpFormRequest(URL url) {
        super(url);
    }

    public HttpFormRequest(URL url, long timeout) {
        super(url, timeout);
    }

    public HttpResult execute(String formData, String file) {
        this.addRequestProperty("Content-Type", "multipart/form-data; boundary=CargoBoundary");
        this.setRequestBody((OutputStream outputStream) -> {
            try (BufferedWriter httpRequestBodyWriter = new BufferedWriter(new OutputStreamWriter(outputStream));){
                httpRequestBodyWriter.write("\r\n--CargoBoundary\r\n");
                httpRequestBodyWriter.write(formData);
                httpRequestBodyWriter.write("\r\nContent-Type: application/octet-stream\r\n\r\n");
                httpRequestBodyWriter.flush();
                this.writeFileToOutputStream(file, outputStream);
                httpRequestBodyWriter.write("\r\n--CargoBoundary--\r\n");
                httpRequestBodyWriter.flush();
            }
            outputStream.close();
        });
        return this.post();
    }

    private void writeFileToOutputStream(String file, OutputStream outputStream) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = input.read(dataBuffer)) != -1) {
                outputStream.write(dataBuffer, 0, bytesRead);
            }
            outputStream.flush();
        }
    }
}

