/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.property.DataSourceConverter;
import org.codehaus.cargo.container.property.ResourceConverter;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.AbstractConfiguration;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractLocalConfiguration
extends AbstractConfiguration
implements LocalConfiguration {
    public static final String RESOURCE_PATH = "org/codehaus/cargo/container/internal/resources/";
    private static final String PORT_OFFSET_APPLIED_PREFIX = LocalConfiguration.class.getName() + "_portOffsetApplied_";
    private List<Deployable> deployables = new ArrayList<Deployable>();
    private List<FileConfig> files;
    private FilterChain filterChain;
    private String home;
    private AntUtils antUtils;
    private ResourceUtils resourceUtils;
    private FileHandler fileHandler = new DefaultFileHandler();
    private List<Resource> resources;
    private List<DataSource> dataSources;
    private List<User> users;

    public AbstractLocalConfiguration(String home) {
        this.antUtils = new AntUtils();
        this.resourceUtils = new ResourceUtils();
        this.resources = new ArrayList<Resource>();
        this.dataSources = new ArrayList<DataSource>();
        this.files = new ArrayList<FileConfig>();
        this.users = new ArrayList<User>();
        this.home = home;
        this.setProperty("cargo.port.offset", "0");
        this.setProperty("cargo.process.spawn", "false");
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.fileHandler.setLogger(logger);
    }

    @Override
    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    @Override
    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    @Override
    public void setFileProperty(FileConfig fileConfig) {
        this.files.add(fileConfig);
    }

    @Override
    public void setConfigFileProperty(FileConfig fileConfig) {
        fileConfig.setOverwrite(true);
        fileConfig.setConfigfile(true);
        this.setFileProperty(fileConfig);
    }

    @Override
    public List<FileConfig> getFileProperties() {
        return this.files;
    }

    @Override
    public synchronized void addDeployable(Deployable newDeployable) {
        this.deployables.add(newDeployable);
    }

    @Override
    public List<Deployable> getDeployables() {
        return this.deployables;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public String getPropertyValue(String name) {
        if (this.isOffsetApplied(name)) {
            return super.getProperties().get(name);
        }
        return super.getPropertyValue(name);
    }

    @Override
    public void configure(LocalContainer container) {
        if (this.getPropertyValue("cargo.java.home") == null) {
            this.setProperty("cargo.java.home", System.getProperty("java.home"));
        }
        this.parsePropertiesForPendingConfiguration();
        this.verify();
        try {
            this.doConfigure(container);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " " + this.getType().getType() + " configuration: " + e.getMessage(), e);
        }
        this.configureFiles(this.getFilterChain(), container);
    }

    protected final FilterChain createFilterChain() {
        this.filterChain = new FilterChain();
        this.getAntUtils().addTokensToFilterChain(this.filterChain, this.getProperties());
        return this.filterChain;
    }

    protected FilterChain getFilterChain() {
        if (this.filterChain == null) {
            this.filterChain = this.createFilterChain();
        }
        return this.filterChain;
    }

    protected void configureFiles(FilterChain filterChain, LocalContainer container) {
        List<FileConfig> files = this.files;
        for (FileConfig fileConfig : files) {
            boolean isDirectory = false;
            if (fileConfig.getFile() == null) {
                throw new RuntimeException("File cannot be null");
            }
            File origFile = new File(fileConfig.getFile());
            if (origFile.isDirectory()) {
                isDirectory = true;
            }
            String destFile = this.getDestFileLocation(fileConfig.getFile(), fileConfig.getToDir(), fileConfig.getToFile());
            if (origFile.exists() && !fileConfig.getOverwrite()) continue;
            if (isDirectory) {
                String destDir = this.getDestDirectoryLocation(fileConfig.getFile(), fileConfig.getToDir());
                if (fileConfig.getConfigfile()) {
                    this.getFileHandler().copyDirectory(fileConfig.getFile(), destDir, filterChain, fileConfig.getEncodingAsCharset());
                    continue;
                }
                this.getFileHandler().copyDirectory(fileConfig.getFile(), destDir);
                continue;
            }
            if (fileConfig.getConfigfile()) {
                this.getFileHandler().copyFile(fileConfig.getFile(), destFile, filterChain, fileConfig.getEncodingAsCharset());
                continue;
            }
            this.getFileHandler().copyFile(fileConfig.getFile(), destFile, fileConfig.getOverwrite());
        }
    }

    protected String getDestFileLocation(String file, String toDir, String toFile) {
        String filename;
        String fileName = file;
        String finalFile = null;
        if (fileName == null) {
            throw new RuntimeException("file cannot be null");
        }
        if (toFile == null && toDir != null) {
            filename = new File(fileName).getName();
            finalFile = this.getHome() + "/" + toDir + "/" + filename;
        } else if (toFile != null && toDir == null) {
            finalFile = this.getHome() + "/" + toFile;
        } else if (toFile == null && toDir == null) {
            filename = new File(fileName).getName();
            finalFile = this.getHome() + "/" + filename;
        } else if (toFile != null && toDir != null) {
            finalFile = this.getHome() + "/" + toDir + "/" + toFile;
        }
        while (finalFile.contains("//")) {
            finalFile = finalFile.replaceAll("//", "/");
        }
        return finalFile;
    }

    protected String getDestDirectoryLocation(String file, String toDir) {
        String fileName = file;
        String finalDir = null;
        if (fileName == null) {
            throw new RuntimeException("file cannot be null");
        }
        if (toDir != null) {
            finalDir = this.getHome() + "/" + toDir;
        } else if (toDir == null) {
            finalDir = this.getHome();
        }
        while (finalDir.contains("//")) {
            finalDir = finalDir.replaceAll("//", "/");
        }
        return finalDir;
    }

    @Override
    public void verify() {
        this.collectUnsupportedResourcesAndThrowException();
        this.collectUnsupportedDataSourcesAndThrowException();
        super.verify();
    }

    public void collectUnsupportedResourcesAndThrowException() {
        if (!this.getResources().isEmpty() && !this.getCapability().supportsProperty("cargo.resource.resource")) {
            StringBuilder errorMessage = new StringBuilder();
            for (Resource resource : this.getResources()) {
                String message = "This configuration does not support Resource configuration! JndiName: " + resource.getName();
                this.getLogger().warn(message, this.getClass().getName());
                if (!errorMessage.toString().isEmpty()) {
                    errorMessage.append("\n");
                }
                errorMessage.append(message);
            }
            throw new CargoException(errorMessage.toString());
        }
    }

    public void collectUnsupportedDataSourcesAndThrowException() {
        StringBuilder errorMessage = new StringBuilder();
        for (DataSource dataSource : this.getDataSources()) {
            String reason = null;
            if (!this.getCapability().supportsProperty("cargo.datasource.datasource")) {
                reason = "This configuration does not support DataSource configuration! ";
            } else if ("javax.sql.XADataSource".equals(dataSource.getConnectionType()) && !this.getCapability().supportsProperty("cargo.datasource.type")) {
                reason = "This configuration does not support XADataSource configured DataSources! ";
            } else if (!("javax.sql.XADataSource".equals(dataSource.getConnectionType()) || TransactionSupport.NO_TRANSACTION.equals(dataSource.getTransactionSupport()) || this.getCapability().supportsProperty("cargo.datasource.transactionsupport"))) {
                reason = "This configuration does not support Transactions on Driver configured DataSources! ";
            }
            if (reason == null) continue;
            String message = reason + "JndiName: " + dataSource.getJndiLocation();
            if (errorMessage.length() > 0) {
                errorMessage.append("\n");
            }
            errorMessage.append(message);
            this.getLogger().warn(message, this.getClass().getName());
        }
        if (errorMessage.length() > 0) {
            throw new CargoException(errorMessage.toString());
        }
    }

    public void parsePropertiesForPendingConfiguration() {
        this.addResourcesFromProperties();
        this.addDataSourcesFromProperties();
        this.addUsersFromProperties();
    }

    protected void addResourcesFromProperties() {
        this.getLogger().debug("Searching properties for Resource definitions", this.getClass().getName());
        for (Map.Entry<String, String> property : this.getProperties().entrySet()) {
            String propertyName = property.getKey();
            if (!propertyName.startsWith("cargo.resource.resource")) continue;
            String resourceProperty = property.getValue();
            this.getLogger().debug("Found Resource definition: value [" + resourceProperty + "]", this.getClass().getName());
            Resource resource = new ResourceConverter().fromPropertyString(resourceProperty);
            this.getResources().add(resource);
        }
    }

    protected void addDataSourcesFromProperties() {
        this.getLogger().debug("Searching properties for DataSource definitions", this.getClass().getName());
        for (Map.Entry<String, String> property : this.getProperties().entrySet()) {
            String propertyName = property.getKey();
            if (!propertyName.startsWith("cargo.datasource.datasource")) continue;
            String dataSourceProperty = property.getValue();
            this.getLogger().debug("Found DataSource definition: value [" + dataSourceProperty + "]", this.getClass().getName());
            DataSource dataSource = new DataSourceConverter().fromPropertyString(dataSourceProperty);
            this.getDataSources().add(dataSource);
        }
    }

    protected void addUsersFromProperties() {
        this.getLogger().debug("Searching properties for User definition", this.getClass().getName());
        String usersProperty = this.getPropertyValue("cargo.servlet.users");
        if (usersProperty != null) {
            this.getLogger().debug("Found User definition: value [" + usersProperty + "]", this.getClass().getName());
            List<User> usersFromProp = User.parseUsers(usersProperty);
            this.getUsers().addAll(usersFromProp);
        }
    }

    protected abstract void doConfigure(LocalContainer var1) throws Exception;

    @Override
    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    @Override
    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    public void addUser(User user) {
        this.users.add(user);
    }

    @Override
    public List<User> getUsers() {
        return this.users;
    }

    @Override
    public void addDataSource(DataSource dataSource) {
        this.dataSources.add(dataSource);
    }

    @Override
    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    public void applyPortOffset() {
        if (this.getPropertyValue("cargo.port.offset") != null && !this.getPropertyValue("cargo.port.offset").equals("0")) {
            HashSet<String> keysCopy = new HashSet<String>(this.getProperties().keySet());
            for (String key : keysCopy) {
                if (!key.startsWith("cargo.") || !key.endsWith(".port")) continue;
                this.applyPortOffset(key);
            }
        }
    }

    @Override
    public void revertPortOffset() {
        if (this.getPropertyValue("cargo.port.offset") != null && !this.getPropertyValue("cargo.port.offset").equals("0")) {
            HashSet<String> keysCopy = new HashSet<String>(this.getProperties().keySet());
            for (String key : keysCopy) {
                if (!key.startsWith("cargo.") || !key.endsWith(".port")) continue;
                this.revertPortOffset(key);
            }
        }
    }

    protected void applyPortOffset(String name) {
        if (this.getPropertyValue("cargo.port.offset") != null && this.getPropertyValue(name) != null && !this.isOffsetApplied(name)) {
            try {
                int portOffset = Integer.parseInt(this.getPropertyValue("cargo.port.offset"));
                int value = Integer.parseInt(this.getPropertyValue(name));
                this.setProperty(name, Integer.toString(value + portOffset));
                this.flagOffsetApplied(name, true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void revertPortOffset(String name) {
        if (this.getPropertyValue("cargo.port.offset") != null && this.getPropertyValue(name) != null && this.isOffsetApplied(name)) {
            try {
                int portOffset = Integer.parseInt(this.getPropertyValue("cargo.port.offset"));
                int value = Integer.parseInt(this.getPropertyValue(name));
                this.setProperty(name, Integer.toString(value - portOffset));
                this.flagOffsetApplied(name, false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isOffsetApplied() {
        return this.isOffsetApplied("cargo.servlet.port");
    }

    protected boolean isOffsetApplied(String name) {
        return super.getPropertyValue(PORT_OFFSET_APPLIED_PREFIX + name) != null;
    }

    protected void flagOffsetApplied(String name, boolean offsetApplied) {
        this.setProperty(PORT_OFFSET_APPLIED_PREFIX + name, offsetApplied ? String.valueOf(offsetApplied) : null);
    }
}

