/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployable;

import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

public abstract class AbstractDeployable
extends LoggedObject
implements Deployable {
    private String file;
    private FileHandler fileHandler;

    public AbstractDeployable(String file) {
        this.file = file;
        this.fileHandler = new DefaultFileHandler();
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    @Override
    public boolean isExpanded() {
        return this.getFileHandler().isDirectory(this.getFile());
    }

    public String toString() {
        if (this.getFileHandler() != null && this.getFile() != null) {
            return this.getClass().getName() + "[" + this.getFileHandler().getName(this.getFile()) + "]";
        }
        return this.getClass().getName() + "[File not set]";
    }

    @Override
    public String getName() {
        String name = this.getFileHandler().getName(this.getFile());
        int nameIndex = name.toLowerCase().lastIndexOf(46);
        if (nameIndex >= 0) {
            name = name.substring(0, nameIndex);
        }
        return name;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object != null && object instanceof AbstractDeployable) {
            return object.toString().equals(this.toString());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

