/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.spi;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.generic.internal.util.HintKey;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;

public abstract class AbstractIntrospectionGenericHintFactory
extends AbstractGenericHintFactory {
    private Map rejectedMappings = new HashMap();

    protected void registerImplementation(String containerId, String objectClassName, String hint) {
        try {
            Class<?> objectClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(objectClassName);
            this.registerImplementation(containerId, hint, objectClass);
        }
        catch (Exception e) {
            this.rejectedMappings.put(new HintKey(containerId, hint), objectClassName);
            this.getMonitor().warn("Not registering class [" + objectClassName + "] for container id [" + containerId + "] as there was an error: [" + e.getMessage() + "]", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected Object createImplementation(String containerId, String hint, AbstractGenericHintFactory.GenericParameters parameters, String implementationConceptName) {
        Object object;
        try {
            object = super.createImplementation(containerId, hint, parameters, implementationConceptName);
        }
        catch (ContainerException e) {
            if (this.rejectedMappings.containsKey(new HintKey(containerId, hint))) {
                throw new ContainerException("Failed to create a " + hint + " " + implementationConceptName + " for container id [" + containerId + "]. The container has not been properly registered for that " + implementationConceptName + " type and that's probably because that " + "container implementation class could not been loaded. Are you sure you " + "have added that container's implementation jar to the classpath?", (Throwable)e);
            }
            throw e;
        }
        return object;
    }
}

