/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.configuration;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.internal.util.FullContainerIdentity;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public class DefaultConfigurationFactory
extends AbstractIntrospectionGenericHintFactory
implements ConfigurationFactory {
    private FileHandler fileHandler = new DefaultFileHandler();

    public DefaultConfigurationFactory() {
        this.registerConfiguration("geronimo1x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.geronimo.Geronimo1xStandaloneLocalConfiguration");
        this.registerConfiguration("geronimo1x", ContainerType.INSTALLED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.geronimo.Geronimo1xExistingLocalConfiguration");
        this.registerConfiguration("jboss3x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.jboss.JBossStandaloneLocalConfiguration");
        this.registerConfiguration("jboss3x", ContainerType.INSTALLED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.jboss.JBossExistingLocalConfiguration");
        this.registerConfiguration("jboss4x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.jboss.JBossStandaloneLocalConfiguration");
        this.registerConfiguration("jboss4x", ContainerType.INSTALLED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.jboss.JBossExistingLocalConfiguration");
        this.registerConfiguration("jboss4x", ContainerType.REMOTE, ConfigurationType.RUNTIME, "org.codehaus.cargo.container.jboss.JBossRuntimeConfiguration");
        this.registerConfiguration("jetty4x", ContainerType.EMBEDDED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.jetty.Jetty4xEmbeddedStandaloneLocalConfiguration");
        this.registerConfiguration("jetty5x", ContainerType.EMBEDDED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.jetty.Jetty5xEmbeddedStandaloneLocalConfiguration");
        this.registerConfiguration("jetty6x", ContainerType.EMBEDDED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.jetty.Jetty6xEmbeddedStandaloneLocalConfiguration");
        this.registerConfiguration("jo1x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.jo.Jo1xStandaloneLocalConfiguration");
        this.registerConfiguration("orion1x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.orion.OrionStandaloneLocalConfiguration");
        this.registerConfiguration("orion2x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.orion.OrionStandaloneLocalConfiguration");
        this.registerConfiguration("oc4j9x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.orion.Oc4j9xStandaloneLocalConfiguration");
        this.registerConfiguration("resin2x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.resin.Resin2xStandaloneLocalConfiguration");
        this.registerConfiguration("resin2x", ContainerType.INSTALLED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.resin.ResinExistingLocalConfiguration");
        this.registerConfiguration("resin3x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.resin.Resin3xStandaloneLocalConfiguration");
        this.registerConfiguration("resin3x", ContainerType.INSTALLED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.resin.ResinExistingLocalConfiguration");
        this.registerConfiguration("tomcat3x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.tomcat.Tomcat3xStandaloneLocalConfiguration");
        this.registerConfiguration("tomcat4x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.tomcat.Tomcat4xStandaloneLocalConfiguration");
        this.registerConfiguration("tomcat4x", ContainerType.INSTALLED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.tomcat.TomcatExistingLocalConfiguration");
        this.registerConfiguration("tomcat4x", ContainerType.REMOTE, ConfigurationType.RUNTIME, "org.codehaus.cargo.container.tomcat.TomcatRuntimeConfiguration");
        this.registerConfiguration("tomcat5x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.tomcat.Tomcat5xStandaloneLocalConfiguration");
        this.registerConfiguration("tomcat5x", ContainerType.EMBEDDED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.tomcat.Tomcat5xStandaloneLocalConfiguration");
        this.registerConfiguration("tomcat5x", ContainerType.INSTALLED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.tomcat.TomcatExistingLocalConfiguration");
        this.registerConfiguration("tomcat5x", ContainerType.EMBEDDED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.tomcat.TomcatExistingLocalConfiguration");
        this.registerConfiguration("tomcat5x", ContainerType.REMOTE, ConfigurationType.RUNTIME, "org.codehaus.cargo.container.tomcat.TomcatRuntimeConfiguration");
        this.registerConfiguration("weblogic8x", ContainerType.INSTALLED, ConfigurationType.STANDALONE, "org.codehaus.cargo.container.weblogic.WebLogicStandaloneLocalConfiguration");
        this.registerConfiguration("weblogic8x", ContainerType.INSTALLED, ConfigurationType.EXISTING, "org.codehaus.cargo.container.weblogic.WebLogicExistingLocalConfiguration");
    }

    public boolean isConfigurationRegistered(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.hasMapping(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()));
    }

    public void registerConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, Class configurationClass) {
        this.registerImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), configurationClass);
    }

    public void registerConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, String configurationClassName) {
        this.registerImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), configurationClassName);
    }

    public Class getConfigurationClass(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.getMapping(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()));
    }

    public Configuration createConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.createConfiguration(containerId, containerType, configurationType, null);
    }

    public Configuration createConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, String home) {
        ConfigurationFactoryParameters parameters = new ConfigurationFactoryParameters();
        parameters.home = home;
        return (Configuration)this.createImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), parameters, "configuration");
    }

    protected Constructor getConstructor(Class configurationClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor constructor;
        if (ConfigurationType.toType((String)hint) == ConfigurationType.RUNTIME) {
            constructor = configurationClass.getConstructor(new Class[0]);
        } else if (ConfigurationType.toType((String)hint) == ConfigurationType.EXISTING || ConfigurationType.toType((String)hint) == ConfigurationType.STANDALONE) {
            constructor = configurationClass.getConstructor(String.class);
        } else {
            throw new ContainerException("Unknown configuration type [" + hint + "]");
        }
        return constructor;
    }

    protected Object createInstance(Constructor constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Object instance;
        String home = ((ConfigurationFactoryParameters)parameters).home;
        if (ConfigurationType.toType((String)hint) == ConfigurationType.RUNTIME) {
            if (home != null) {
                throw new ContainerException("The configuration home parameter should not be specified for runtime configurations");
            }
            instance = constructor.newInstance(new Object[0]);
        } else if (ConfigurationType.toType((String)hint) == ConfigurationType.EXISTING || ConfigurationType.toType((String)hint) == ConfigurationType.STANDALONE) {
            if (home == null) {
                if (ConfigurationType.toType((String)hint) == ConfigurationType.EXISTING) {
                    throw new ContainerException("The configuration home parameter must be specified for existing configurations");
                }
                home = this.fileHandler.getTmpPath("conf");
            }
            instance = constructor.newInstance(home);
        } else {
            throw new ContainerException("Unknown configuration type [" + hint + "]");
        }
        return instance;
    }

    private static class ConfigurationFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public String home;

        private ConfigurationFactoryParameters() {
        }
    }
}

