/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.tools.SPInterface;
import org.apache.commons.discovery.tools.Service;
import org.codehaus.cargo.generic.ContainerCapabilityFactory;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.configuration.ConfigurationCapabilityFactory;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.deployable.DeployableFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.generic.packager.PackagerFactory;

public abstract class AbstractFactoryRegistry {
    public static void register(ClassLoader classLoader, DeployableFactory factory) {
        Iterator itr = AbstractFactoryRegistry.list(classLoader).iterator();
        while (itr.hasNext()) {
            ((AbstractFactoryRegistry)itr.next()).register(factory);
        }
    }

    public static void register(ClassLoader classLoader, ConfigurationFactory factory) {
        Iterator itr = AbstractFactoryRegistry.list(classLoader).iterator();
        while (itr.hasNext()) {
            ((AbstractFactoryRegistry)itr.next()).register(factory);
        }
    }

    public static void register(ClassLoader classLoader, ConfigurationCapabilityFactory factory) {
        Iterator itr = AbstractFactoryRegistry.list(classLoader).iterator();
        while (itr.hasNext()) {
            ((AbstractFactoryRegistry)itr.next()).register(factory);
        }
    }

    public static void register(ClassLoader classLoader, DeployerFactory factory) {
        Iterator itr = AbstractFactoryRegistry.list(classLoader).iterator();
        while (itr.hasNext()) {
            ((AbstractFactoryRegistry)itr.next()).register(factory);
        }
    }

    public static void register(ClassLoader classLoader, PackagerFactory factory) {
        Iterator itr = AbstractFactoryRegistry.list(classLoader).iterator();
        while (itr.hasNext()) {
            ((AbstractFactoryRegistry)itr.next()).register(factory);
        }
    }

    public static void register(ClassLoader classLoader, ContainerFactory factory) {
        Iterator itr = AbstractFactoryRegistry.list(classLoader).iterator();
        while (itr.hasNext()) {
            ((AbstractFactoryRegistry)itr.next()).register(factory);
        }
    }

    public static void register(ClassLoader classLoader, ContainerCapabilityFactory factory) {
        Iterator itr = AbstractFactoryRegistry.list(classLoader).iterator();
        while (itr.hasNext()) {
            ((AbstractFactoryRegistry)itr.next()).register(factory);
        }
    }

    protected abstract void register(DeployableFactory var1);

    protected abstract void register(ConfigurationCapabilityFactory var1);

    protected abstract void register(ConfigurationFactory var1);

    protected abstract void register(DeployerFactory var1);

    protected abstract void register(PackagerFactory var1);

    protected abstract void register(ContainerFactory var1);

    protected abstract void register(ContainerCapabilityFactory var1);

    private static List list(ClassLoader classLoader) {
        ClassLoaders loaders = new ClassLoaders();
        ClassLoader cl = classLoader;
        if (cl != null) {
            loaders.put(cl);
        }
        if ((cl = Thread.currentThread().getContextClassLoader()) != null) {
            loaders.put(cl);
        }
        if ((cl = AbstractFactoryRegistry.class.getClassLoader()) != null) {
            loaders.put(cl);
        }
        if ((cl = JDKHooks.getJDKHooks().getSystemClassLoader()) != null) {
            loaders.put(cl);
        }
        if (loaders.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList registries = new ArrayList();
        Enumeration providers = Service.providers((SPInterface)new SPInterface(AbstractFactoryRegistry.class), (ClassLoaders)loaders);
        if (!providers.hasMoreElements()) {
            throw new IllegalStateException("No containers found!");
        }
        while (providers.hasMoreElements()) {
            Object provider = providers.nextElement();
            if (!(provider instanceof AbstractFactoryRegistry)) continue;
            registries.add(provider);
        }
        return registries;
    }
}

