/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.deployer;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

public class DefaultDeployerFactory
extends AbstractIntrospectionGenericHintFactory
implements DeployerFactory {
    public DefaultDeployerFactory() {
        this(null);
    }

    public DefaultDeployerFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    public void registerDeployer(String containerId, DeployerType deployerType, Class deployerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()), deployerClass);
    }

    public void registerDeployer(String containerId, DeployerType deployerType, String deployerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()), deployerClassName);
    }

    public boolean isDeployerRegistered(String containerId, DeployerType deployerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()));
    }

    public Class getDeployerClass(String containerId, DeployerType deployerType) {
        return this.getMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()));
    }

    public Deployer createDeployer(Container container, DeployerType deployerType) {
        DeployerFactoryParameters parameters = new DeployerFactoryParameters();
        parameters.container = container;
        return (Deployer)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(container.getId()), deployerType.getType()), parameters, "deployer");
    }

    public Deployer createDeployer(Container container) {
        DeployerType type = DeployerType.toType((ContainerType)container.getType());
        if (!this.isDeployerRegistered(container.getId(), type)) {
            throw new ContainerException("There's no registered deployer matching your container's type of [" + container.getType().getType() + "]");
        }
        this.getLogger().debug("Creating a default [" + type + "] deployer", this.getClass().getName());
        Deployer deployer = this.createDeployer(container, type);
        return deployer;
    }

    protected Constructor getConstructor(Class deployerClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor constructor;
        DeployerType type = DeployerType.toType((String)hint);
        if (type == DeployerType.INSTALLED) {
            constructor = deployerClass.getConstructor(InstalledLocalContainer.class);
        } else if (type == DeployerType.EMBEDDED) {
            constructor = deployerClass.getConstructor(EmbeddedLocalContainer.class);
        } else if (type == DeployerType.REMOTE) {
            constructor = deployerClass.getConstructor(RemoteContainer.class);
        } else {
            throw new ContainerException("Unknown deployer type [" + type.getType() + "]");
        }
        return constructor;
    }

    protected Object createInstance(Constructor constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Container container = ((DeployerFactoryParameters)parameters).container;
        return constructor.newInstance(container);
    }

    private static class DeployerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public Container container;

        private DeployerFactoryParameters() {
        }
    }
}

