/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.packager;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.packager.Packager;
import org.codehaus.cargo.container.packager.PackagerType;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.packager.PackagerFactory;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

public class DefaultPackagerFactory
extends AbstractIntrospectionGenericHintFactory
implements PackagerFactory {
    public DefaultPackagerFactory() {
        this(null);
    }

    public DefaultPackagerFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    public void registerPackager(String containerId, PackagerType packagerType, Class packagerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), packagerType.getType()), packagerClass);
    }

    public void registerPackager(String containerId, PackagerType packagerType, String packagerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), packagerType.getType()), packagerClassName);
    }

    public boolean isPackagerRegistered(String containerId, PackagerType packagerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), packagerType.getType()));
    }

    public Packager createPackager(String containerId, PackagerType packagerType, String outputLocation) {
        PackagerFactoryParameters parameters = new PackagerFactoryParameters();
        parameters.outputLocation = outputLocation;
        return (Packager)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), packagerType.getType()), parameters, "packager");
    }

    protected Constructor getConstructor(Class deployerClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        PackagerType type = PackagerType.toType((String)hint);
        if (type != PackagerType.DIRECTORY) {
            throw new ContainerException("Unknown packager type [" + type.getType() + "]");
        }
        Constructor constructor = deployerClass.getConstructor(String.class);
        return constructor;
    }

    protected Object createInstance(Constructor constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        String outputLocation = ((PackagerFactoryParameters)parameters).outputLocation;
        return constructor.newInstance(outputLocation);
    }

    private static class PackagerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public String outputLocation;

        private PackagerFactoryParameters() {
        }
    }
}

